/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsFindStemsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestFindStemsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemQueryFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcFindStems {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private WsStemQueryFilter wsStemQueryFilter;
    private String clientVersion;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Set<String> stemNames = new LinkedHashSet<String>();
    private Set<String> stemUuids = new LinkedHashSet<String>();
    private Set<Long> stemIdIndexes = new LinkedHashSet<Long>();

    public GcFindStems assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcFindStems assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcFindStems assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcFindStems assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcFindStems assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcFindStems assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcFindStems assignStemQueryFilter(WsStemQueryFilter theStemQueryFilter) {
        this.wsStemQueryFilter = theStemQueryFilter;
        return this;
    }

    public GcFindStems assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcFindStems addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcFindStems addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcFindStems assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (this.wsStemQueryFilter == null && GrouperClientUtils.length(this.stemUuids) == 0 && GrouperClientUtils.length(this.stemNames) == 0 && GrouperClientUtils.length(this.stemIdIndexes) == 0) {
            throw new RuntimeException("Need to pass in a stem query filter, or stemNames or stemUuids or stemIdIndexes: " + this);
        }
    }

    public WsFindStemsResults execute() {
        this.validate();
        WsFindStemsResults wsFindStemsResults = null;
        try {
            WsRestFindStemsRequest findStems = new WsRestFindStemsRequest();
            findStems.setActAsSubjectLookup(this.actAsSubject);
            findStems.setWsStemQueryFilter(this.wsStemQueryFilter);
            if (this.params.size() > 0) {
                findStems.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            ArrayList<WsStemLookup> stemLookups = new ArrayList<WsStemLookup>();
            for (String stemName : this.stemNames) {
                stemLookups.add(new WsStemLookup(stemName, null));
            }
            for (String stemUuid : this.stemUuids) {
                stemLookups.add(new WsStemLookup(null, stemUuid));
            }
            for (Long stemIdIndex : this.stemIdIndexes) {
                stemLookups.add(new WsStemLookup(null, null, stemIdIndex.toString()));
            }
            findStems.setWsStemLookups(GrouperClientUtils.toArray(stemLookups, WsStemLookup.class));
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsFindStemsResults = (WsFindStemsResults)grouperClientWs.executeService("stems", findStems, "findStems", this.clientVersion, true);
            String resultMessage = wsFindStemsResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsFindStemsResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsFindStemsResults;
    }

    public GcFindStems addStemName(String theStemName) {
        this.stemNames.add(theStemName);
        return this;
    }

    public GcFindStems addStemUuid(String theStemUuid) {
        this.stemUuids.add(theStemUuid);
        return this;
    }

    public GcFindStems addStemIdIndex(Long theStemIdIndex) {
        this.stemIdIndexes.add(theStemIdIndex);
        return this;
    }
}

