/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GcWebServiceError;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefName;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameSaveResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameToSave;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAttributeDefNameSaveRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GcAttributeDefNameSave {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private String clientVersion;
    private List<WsAttributeDefNameToSave> attributeDefNamesToSave = new ArrayList<WsAttributeDefNameToSave>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private GcTransactionType txType;

    public GcAttributeDefNameSave assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcAttributeDefNameSave assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcAttributeDefNameSave assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcAttributeDefNameSave assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcAttributeDefNameSave assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcAttributeDefNameSave assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcAttributeDefNameSave assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcAttributeDefNameSave addAttributeDefNameToSave(WsAttributeDefNameToSave wsAttributeDefNameToSave) {
        this.attributeDefNamesToSave.add(wsAttributeDefNameToSave);
        return this;
    }

    public GcAttributeDefNameSave addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAttributeDefNameSave addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAttributeDefNameSave assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.attributeDefNamesToSave) == 0) {
            throw new RuntimeException("AttributeDefName name is required: " + this);
        }
    }

    public WsAttributeDefNameSaveResults execute() {
        this.validate();
        WsAttributeDefNameSaveResults wsAttributeDefNameSaveResults = null;
        try {
            WsRestAttributeDefNameSaveRequest attributeDefNameSave = new WsRestAttributeDefNameSaveRequest();
            attributeDefNameSave.setActAsSubjectLookup(this.actAsSubject);
            attributeDefNameSave.setTxType(this.txType == null ? null : this.txType.name());
            attributeDefNameSave.setWsAttributeDefNameToSaves(GrouperClientUtils.toArray(this.attributeDefNamesToSave, WsAttributeDefNameToSave.class));
            if (this.params.size() > 0) {
                attributeDefNameSave.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsAttributeDefNameSaveResults = (WsAttributeDefNameSaveResults)grouperClientWs.executeService("attributeDefNames", attributeDefNameSave, "attributeDefNameSave", this.clientVersion, false);
            String attributeDefNameSaveResultMessage = "";
            try {
                attributeDefNameSaveResultMessage = wsAttributeDefNameSaveResults.getResults()[0].getResultMetadata().getResultMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String resultMessage = wsAttributeDefNameSaveResults.getResultMetadata().getResultMessage() + "\n" + attributeDefNameSaveResultMessage;
            grouperClientWs.handleFailure(wsAttributeDefNameSaveResults, wsAttributeDefNameSaveResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAttributeDefNameSaveResults;
    }

    public GcAttributeDefNameSave assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public static void main(String[] args) {
        WsAttributeDefNameToSave wsAttributeDefNameToSave = new WsAttributeDefNameToSave();
        wsAttributeDefNameToSave.setSaveMode("INSERT");
        WsAttributeDefName wsAttributeDefName = new WsAttributeDefName();
        wsAttributeDefName.setDisplayExtension("an attribute def name 5");
        wsAttributeDefName.setName("stem:anAttributeDefName5");
        wsAttributeDefName.setAttributeDefName("stem:permissionDef");
        wsAttributeDefNameToSave.setWsAttributeDefName(wsAttributeDefName);
        try {
            WsAttributeDefNameSaveResults wsAttributeDefNameSaveResults = new GcAttributeDefNameSave().addAttributeDefNameToSave(wsAttributeDefNameToSave).execute();
            System.out.println(wsAttributeDefNameSaveResults.getResults()[0].getResultMetadata().getResultCode());
        }
        catch (GcWebServiceError gwse) {
            WsAttributeDefNameSaveResults wsAttributeDefNameSaveResults = (WsAttributeDefNameSaveResults)gwse.getContainerResponseObject();
            System.out.println(wsAttributeDefNameSaveResults.getResults()[0].getResultMetadata().getResultCode());
            gwse.printStackTrace();
        }
    }
}

