/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameDeleteResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAttributeDefNameDeleteRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GcAttributeDefNameDelete {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private List<WsAttributeDefNameLookup> attributeDefNameLookups = new ArrayList<WsAttributeDefNameLookup>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private GcTransactionType txType;
    private String clientVersion;

    public GcAttributeDefNameDelete assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcAttributeDefNameDelete assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcAttributeDefNameDelete assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcAttributeDefNameDelete assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcAttributeDefNameDelete assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcAttributeDefNameDelete assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcAttributeDefNameDelete addAttributeDefNameLookup(WsAttributeDefNameLookup wsAttributeDefNameLookup) {
        this.attributeDefNameLookups.add(wsAttributeDefNameLookup);
        return this;
    }

    public GcAttributeDefNameDelete addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAttributeDefNameDelete addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAttributeDefNameDelete assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.attributeDefNameLookups) == 0) {
            throw new RuntimeException("Need at least one attributeDefName to delete: " + this);
        }
    }

    public GcAttributeDefNameDelete assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public GcAttributeDefNameDelete assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsAttributeDefNameDeleteResults execute() {
        this.validate();
        WsAttributeDefNameDeleteResults wsAttributeDefNameDeleteResults = null;
        try {
            WsRestAttributeDefNameDeleteRequest attributeDefNameDelete = new WsRestAttributeDefNameDeleteRequest();
            attributeDefNameDelete.setActAsSubjectLookup(this.actAsSubject);
            attributeDefNameDelete.setTxType(this.txType == null ? null : this.txType.name());
            attributeDefNameDelete.setWsAttributeDefNameLookups(GrouperClientUtils.toArray(this.attributeDefNameLookups, WsAttributeDefNameLookup.class));
            if (this.params.size() > 0) {
                attributeDefNameDelete.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsAttributeDefNameDeleteResults = (WsAttributeDefNameDeleteResults)grouperClientWs.executeService("attributeDefNames", attributeDefNameDelete, "attributeDefNameDelete", this.clientVersion, false);
            String resultMessage = wsAttributeDefNameDeleteResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsAttributeDefNameDeleteResults, wsAttributeDefNameDeleteResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAttributeDefNameDeleteResults;
    }
}

