/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignGrouperPrivilegesLiteResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAssignGrouperPrivilegesLiteRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcAssignGrouperPrivilegesLite {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private Boolean allowed = null;
    private String groupName;
    private String privilegeType;
    private String privilegeName;
    private String stemName;
    private WsSubjectLookup subjectLookup = null;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private String clientVersion;

    public GcAssignGrouperPrivilegesLite assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcAssignGrouperPrivilegesLite assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcAssignGrouperPrivilegesLite assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcAssignGrouperPrivilegesLite assignAllowed(boolean isAllowed) {
        this.allowed = isAllowed;
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignPrivilegeType(String thePrivilegeType) {
        this.privilegeType = thePrivilegeType;
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignPrivilegeName(String thePrivilegeName) {
        this.privilegeName = thePrivilegeName;
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignGroupName(String theGroupName) {
        this.groupName = theGroupName;
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignStemName(String theStemName) {
        this.stemName = theStemName;
        return this;
    }

    public GcAssignGrouperPrivilegesLite addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAssignGrouperPrivilegesLite addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.subjectLookup = wsSubjectLookup;
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.params) > 2) {
            throw new RuntimeException("Params can only be size 2 for this request");
        }
        if (this.allowed == null) {
            throw new RuntimeException("Specify true or false for is allowed");
        }
    }

    public GcAssignGrouperPrivilegesLite addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public GcAssignGrouperPrivilegesLite assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsAssignGrouperPrivilegesLiteResult execute() {
        this.validate();
        WsAssignGrouperPrivilegesLiteResult wsAssignGrouperPrivilegesLiteResult = null;
        try {
            WsRestAssignGrouperPrivilegesLiteRequest wsAssignGrouperPrivilegesLite = new WsRestAssignGrouperPrivilegesLiteRequest();
            if (this.actAsSubject != null) {
                wsAssignGrouperPrivilegesLite.setActAsSubjectId(this.actAsSubject.getSubjectId());
                wsAssignGrouperPrivilegesLite.setActAsSubjectIdentifier(this.actAsSubject.getSubjectIdentifier());
                wsAssignGrouperPrivilegesLite.setActAsSubjectSourceId(this.actAsSubject.getSubjectSourceId());
            }
            if (this.includeGroupDetail != null) {
                wsAssignGrouperPrivilegesLite.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                wsAssignGrouperPrivilegesLite.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            wsAssignGrouperPrivilegesLite.setGroupName(this.groupName);
            wsAssignGrouperPrivilegesLite.setStemName(this.stemName);
            wsAssignGrouperPrivilegesLite.setPrivilegeType(this.privilegeType);
            wsAssignGrouperPrivilegesLite.setPrivilegeName(this.privilegeName);
            if (this.subjectAttributeNames.size() > 0) {
                wsAssignGrouperPrivilegesLite.setSubjectAttributeNames(GrouperClientUtils.join(this.subjectAttributeNames.iterator(), ','));
            }
            if (this.subjectLookup != null) {
                wsAssignGrouperPrivilegesLite.setSubjectId(this.subjectLookup.getSubjectId());
                wsAssignGrouperPrivilegesLite.setSubjectIdentifier(this.subjectLookup.getSubjectIdentifier());
                wsAssignGrouperPrivilegesLite.setSubjectId(this.subjectLookup.getSubjectId());
            }
            if (this.params.size() > 0) {
                wsAssignGrouperPrivilegesLite.setParamName0(this.params.get(0).getParamName());
                wsAssignGrouperPrivilegesLite.setParamValue0(this.params.get(0).getParamValue());
            }
            if (this.params.size() > 1) {
                wsAssignGrouperPrivilegesLite.setParamName1(this.params.get(1).getParamName());
                wsAssignGrouperPrivilegesLite.setParamValue1(this.params.get(1).getParamValue());
            }
            if (this.allowed != null) {
                wsAssignGrouperPrivilegesLite.setAllowed(this.allowed != false ? "T" : "F");
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsAssignGrouperPrivilegesLiteResult = (WsAssignGrouperPrivilegesLiteResult)grouperClientWs.executeService("grouperPrivileges", wsAssignGrouperPrivilegesLite, "assignGrouperPrivilegesLite", this.clientVersion, false);
            String resultMessage = wsAssignGrouperPrivilegesLiteResult.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsAssignGrouperPrivilegesLiteResult, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAssignGrouperPrivilegesLiteResult;
    }
}

