/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignAttributeDefNameInheritanceResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAssignAttributeDefNameInheritanceRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GcAssignAttributeDefNameInheritance {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private String clientVersion;
    private WsAttributeDefNameLookup attributeDefNameLookup = null;
    private List<WsAttributeDefNameLookup> relatedAttributeDefNameLookups = new ArrayList<WsAttributeDefNameLookup>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean assign;
    private Boolean replaceAllExisting;
    private GcTransactionType txType;

    public GcAssignAttributeDefNameInheritance assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcAssignAttributeDefNameInheritance assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcAssignAttributeDefNameInheritance assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcAssignAttributeDefNameInheritance assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcAssignAttributeDefNameInheritance assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcAssignAttributeDefNameInheritance assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcAssignAttributeDefNameInheritance assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcAssignAttributeDefNameInheritance assignAttributeDefNameLookup(WsAttributeDefNameLookup wsAttributeDefNameLookup0) {
        this.attributeDefNameLookup = wsAttributeDefNameLookup0;
        return this;
    }

    public GcAssignAttributeDefNameInheritance addRelatedAttributeDefNameLookup(WsAttributeDefNameLookup relatedAttributeDefNameLookup) {
        this.relatedAttributeDefNameLookups.add(relatedAttributeDefNameLookup);
        return this;
    }

    public GcAssignAttributeDefNameInheritance addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAssignAttributeDefNameInheritance addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAssignAttributeDefNameInheritance assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    public GcAssignAttributeDefNameInheritance assign(Boolean isAssign) {
        this.assign = isAssign;
        return this;
    }

    public GcAssignAttributeDefNameInheritance assignReplaceAllExisting(Boolean replaceAllExisting1) {
        this.replaceAllExisting = replaceAllExisting1;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.relatedAttributeDefNameLookups) == 0) {
            throw new RuntimeException("Related AttributeDefName name is required: " + this);
        }
        if (this.attributeDefNameLookup == null || GrouperClientUtils.isBlank(this.attributeDefNameLookup.getName()) && GrouperClientUtils.isBlank(this.attributeDefNameLookup.getUuid())) {
            throw new RuntimeException("Related AttributeDefName name is required: " + this);
        }
        if (this.assign == null) {
            throw new RuntimeException("Assign is required, true means you are assigning, false means you are removing a direct assignment");
        }
    }

    public WsAssignAttributeDefNameInheritanceResults execute() {
        this.validate();
        WsAssignAttributeDefNameInheritanceResults wsAssignAttributeDefNameInheritanceResults = null;
        try {
            WsRestAssignAttributeDefNameInheritanceRequest assignAttributeDefNameInheritance = new WsRestAssignAttributeDefNameInheritanceRequest();
            assignAttributeDefNameInheritance.setActAsSubjectLookup(this.actAsSubject);
            assignAttributeDefNameInheritance.setTxType(this.txType == null ? null : this.txType.name());
            assignAttributeDefNameInheritance.setRelatedWsAttributeDefNameLookups(GrouperClientUtils.toArray(this.relatedAttributeDefNameLookups, WsAttributeDefNameLookup.class));
            assignAttributeDefNameInheritance.setWsAttributeDefNameLookup(this.attributeDefNameLookup);
            if (this.assign != null) {
                assignAttributeDefNameInheritance.setAssign(this.assign != false ? "T" : "F");
            }
            if (this.replaceAllExisting != null) {
                assignAttributeDefNameInheritance.setReplaceAllExisting(this.replaceAllExisting != false ? "T" : "F");
            }
            if (this.params.size() > 0) {
                assignAttributeDefNameInheritance.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsAssignAttributeDefNameInheritanceResults = (WsAssignAttributeDefNameInheritanceResults)grouperClientWs.executeService("attributeDefNames", assignAttributeDefNameInheritance, "assignAttributeDefNameInheritance", this.clientVersion, false);
            String attributeDefNameSaveResultMessage = "";
            try {
                attributeDefNameSaveResultMessage = wsAssignAttributeDefNameInheritanceResults.getResultMetadata().getResultMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String resultMessage = wsAssignAttributeDefNameInheritanceResults.getResultMetadata().getResultMessage() + "\n" + attributeDefNameSaveResultMessage;
            grouperClientWs.handleFailure(wsAssignAttributeDefNameInheritanceResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAssignAttributeDefNameInheritanceResults;
    }

    public GcAssignAttributeDefNameInheritance assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public static void main(String[] args) {
    }
}

