/*
 * Decompiled with CFR 0.152.
 */
package dev.scheibelhofer.crypto.provider;

import dev.scheibelhofer.crypto.provider.Pem;
import dev.scheibelhofer.crypto.provider.PemKeystoreException;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import java.util.List;

class PemWriter
implements Closeable,
Flushable {
    private BufferedWriter writer;
    private boolean writeAliasLine;

    PemWriter(OutputStream os, boolean writeAliasLine) {
        this.writer = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
        this.writeAliasLine = writeAliasLine;
    }

    void writeEntry(Pem.Entry entry) {
        switch (entry.type) {
            case privateKey: {
                this.writePemEntry(entry.alias, entry.encoding, "-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----");
                break;
            }
            case encryptedPrivateKey: {
                this.writePemEntry(entry.alias, entry.encoding, "-----BEGIN ENCRYPTED PRIVATE KEY-----", "-----END ENCRYPTED PRIVATE KEY-----");
                break;
            }
            case certificate: {
                this.writePemEntry(entry.alias, entry.encoding, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
                break;
            }
            case unknown: {
                this.writePemEntry(entry.alias, entry.encoding, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
            }
        }
    }

    void writePemEntry(String alias, byte[] encoding, String beginLine, String endLine) {
        try {
            if (this.writeAliasLine && alias != null) {
                this.writer.write("Alias: ");
                this.writer.write(alias);
                this.writer.write("\n");
            }
            this.writer.write(beginLine);
            this.writer.write("\n");
            this.writer.write(Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(encoding));
            this.writer.write("\n");
            this.writer.write(endLine);
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new PemKeystoreException("failed writing PEM entry", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public static void write(Path filePath, Pem.Entry entry) {
        try (PemWriter pw = new PemWriter(new FileOutputStream(filePath.toFile()), false);){
            pw.writeEntry(entry);
        }
        catch (IOException e) {
            throw new PemKeystoreException("failed writing PEM entry to file " + filePath, e);
        }
    }

    public static void write(Path filePath, List<Pem.CertificateEntry> certificateChainEntries) {
        try (PemWriter pw = new PemWriter(new FileOutputStream(filePath.toFile()), false);){
            certificateChainEntries.stream().forEach(c -> pw.writeEntry((Pem.Entry)c));
        }
        catch (IOException e) {
            throw new PemKeystoreException("failed writing PEM entry to file " + filePath, e);
        }
    }
}

