/*
 * Decompiled with CFR 0.152.
 */
package dev.scheibelhofer.crypto.provider;

import dev.scheibelhofer.crypto.provider.Pem;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;

class PemReader
implements Closeable {
    private BufferedReader reader;
    private String aliasCandidate;

    PemReader(InputStream is, String aliasCandidate) {
        this.reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        this.aliasCandidate = aliasCandidate;
    }

    List<Pem.Entry> readEntries() throws IOException {
        Pem.Entry entry;
        ArrayList<Pem.Entry> entries = new ArrayList<Pem.Entry>();
        while ((entry = this.readEntry()) != null) {
            entries.add(entry);
        }
        return entries;
    }

    Pem.Entry readEntry() throws IOException {
        String line;
        StringBuilder sb = new StringBuilder(1024);
        Pem.Entry entry = new Pem.Entry(Pem.Entry.Type.unknown);
        String alias = this.aliasCandidate;
        while ((line = this.reader.readLine()) != null && !line.startsWith("-----BEGIN")) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty() || !trimmedLine.toLowerCase(Locale.US).startsWith("alias:")) continue;
            alias = trimmedLine.substring(trimmedLine.indexOf(58) + 1, trimmedLine.length()).trim();
        }
        if (line != null) {
            switch (line) {
                case "-----BEGIN CERTIFICATE-----": {
                    entry = new Pem.CertificateEntry(alias);
                    break;
                }
                case "-----BEGIN PRIVATE KEY-----": {
                    entry = new Pem.PrivateKeyEntry(alias);
                    break;
                }
                case "-----BEGIN ENCRYPTED PRIVATE KEY-----": {
                    entry = new Pem.EncryptedPrivateKeyEntry(alias);
                    break;
                }
                default: {
                    entry = new Pem.UnknownEntry(alias, line);
                }
            }
        }
        while ((line = this.reader.readLine()) != null && !line.startsWith("-----END")) {
            sb.append(line);
        }
        String base64 = sb.toString().trim();
        if (base64.length() == 0) {
            return null;
        }
        entry.initFromEncoding(Base64.getMimeDecoder().decode(sb.toString()));
        return entry;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

