/*
 * Decompiled with CFR 0.152.
 */
package dev.scheibelhofer.crypto.provider;

import dev.scheibelhofer.crypto.provider.Pem;
import dev.scheibelhofer.crypto.provider.PemKeystore;
import dev.scheibelhofer.crypto.provider.PemKeystoreException;
import dev.scheibelhofer.crypto.provider.PemReader;
import dev.scheibelhofer.crypto.provider.PemWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.LinkedList;

public class PemFileKeystore
extends PemKeystore {
    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (PemWriter pemOut = new PemWriter(stream, true);){
            this.privateKeys.values().stream().forEach(pke -> pemOut.writeEntry((Pem.Entry)pke));
            this.encryptedPrivateKeys.values().stream().forEach(epke -> pemOut.writeEntry((Pem.Entry)epke));
            this.certificateChains.values().stream().forEach(cce -> cce.stream().forEach(c -> pemOut.writeEntry((Pem.Entry)c)));
            this.certificates.values().stream().forEach(pke -> pemOut.writeEntry((Pem.Entry)pke));
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream == null) {
            this.clearKeystore();
            return;
        }
        try (PemReader pemReader = new PemReader(stream, null);){
            LinkedList<Pem.CertificateEntry> certList = new LinkedList<Pem.CertificateEntry>();
            for (Pem.Entry entry : pemReader.readEntries()) {
                switch (entry.type) {
                    case certificate: {
                        certList.add((Pem.CertificateEntry)entry);
                        break;
                    }
                    case privateKey: {
                        this.privateKeys.put(this.makeUniqueAlias(this.privateKeys.keySet(), entry), (Pem.PrivateKeyEntry)entry);
                        break;
                    }
                    case encryptedPrivateKey: {
                        Pem.EncryptedPrivateKeyEntry epk = (Pem.EncryptedPrivateKeyEntry)entry;
                        this.encryptedPrivateKeys.put(this.makeUniqueAlias(this.encryptedPrivateKeys.keySet(), entry), epk);
                        try {
                            epk.decryptPrivateKey(password);
                        }
                        catch (PemKeystoreException pemKeystoreException) {}
                        break;
                    }
                }
            }
            this.buildCertChains(certList);
            certList.stream().forEach(c -> this.certificates.put(this.makeUniqueAlias(this.certificates.keySet(), c.certificate.getSubjectX500Principal().getName()), c));
        }
        catch (PemKeystoreException e) {
            throw new IOException("error loading key", e);
        }
    }
}

