/*
 * Decompiled with CFR 0.152.
 */
package dev.scheibelhofer.crypto.provider;

import dev.scheibelhofer.crypto.provider.Pem;
import dev.scheibelhofer.crypto.provider.PemKeystore;
import dev.scheibelhofer.crypto.provider.PemKeystoreException;
import dev.scheibelhofer.crypto.provider.PemReader;
import dev.scheibelhofer.crypto.provider.PemWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PemDirectoryKeystore
extends PemKeystore {
    final Set<String> FILE_EXTENSIONS = Set.of(".crt", ".pem");
    private Path keystorePath;

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (!Files.exists(this.keystorePath, new LinkOption[0])) {
            Files.createDirectories(this.keystorePath, new FileAttribute[0]);
        } else if (!Files.isDirectory(this.keystorePath, new LinkOption[0])) {
            throw new IOException("the provided path name during the previous call of load() must denote a directory, if it exists, it was " + this.keystorePath);
        }
        this.privateKeys.entrySet().stream().forEach(pke -> PemWriter.write(this.keystorePath.resolve((String)pke.getKey() + ".pem"), (Pem.Entry)pke.getValue()));
        this.encryptedPrivateKeys.entrySet().stream().forEach(epke -> PemWriter.write(this.keystorePath.resolve((String)epke.getKey() + ".pem"), (Pem.Entry)epke.getValue()));
        this.certificateChains.entrySet().stream().forEach(cce -> PemWriter.write(this.keystorePath.resolve((String)cce.getKey() + ".crt"), (List)cce.getValue()));
        this.certificates.entrySet().stream().forEach(pke -> PemWriter.write(this.keystorePath.resolve((String)pke.getKey() + ".crt"), (Pem.Entry)pke.getValue()));
        stream.close();
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream == null) {
            this.clearKeystore();
            return;
        }
        String keystoreFolderName = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
        this.keystorePath = Paths.get(keystoreFolderName, new String[0]);
        Stream<Path> keystoreFiles = Files.isDirectory(this.keystorePath, new LinkOption[0]) ? Files.walk(this.keystorePath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])) : (Files.isRegularFile(this.keystorePath, new LinkOption[0]) ? Stream.of(this.keystorePath) : Stream.empty());
        List<Path> pathList = keystoreFiles.filter(path -> this.FILE_EXTENSIONS.contains(PemDirectoryKeystore.getFileExtension(path))).collect(Collectors.toList());
        this.readKeystore(pathList, password);
    }

    static String getFileExtension(Path p) {
        String name = p.getFileName().toString();
        int lastDotIndex = name.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return "";
        }
        return name.substring(lastDotIndex);
    }

    static String getFileBasename(Path p) {
        String name = p.getFileName().toString();
        int lastDotIndex = name.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return name;
        }
        return name.substring(0, lastDotIndex);
    }

    void readKeystore(List<Path> pathList, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        LinkedList<Pem.CertificateEntry> certList = new LinkedList<Pem.CertificateEntry>();
        for (Path filePath : pathList) {
            String aliasCandidate = PemDirectoryKeystore.getFileBasename(filePath);
            try (PemReader pemReader = new PemReader(new FileInputStream(filePath.toFile()), aliasCandidate);){
                for (Pem.Entry entry : pemReader.readEntries()) {
                    switch (entry.type) {
                        case certificate: {
                            certList.add((Pem.CertificateEntry)entry);
                            break;
                        }
                        case privateKey: {
                            this.privateKeys.put(this.makeUniqueAlias(this.privateKeys.keySet(), entry), (Pem.PrivateKeyEntry)entry);
                            break;
                        }
                        case encryptedPrivateKey: {
                            Pem.EncryptedPrivateKeyEntry epk = (Pem.EncryptedPrivateKeyEntry)entry;
                            this.encryptedPrivateKeys.put(this.makeUniqueAlias(this.encryptedPrivateKeys.keySet(), entry), epk);
                            try {
                                epk.decryptPrivateKey(password);
                            }
                            catch (PemKeystoreException pemKeystoreException) {}
                            break;
                        }
                    }
                }
            }
            catch (PemKeystoreException e) {
                throw new IOException("error loading key", e);
            }
        }
        this.buildCertChains(certList);
        certList.stream().forEach(c -> this.certificates.put(this.makeUniqueAlias(this.certificates.keySet(), c.certificate.getSubjectX500Principal().getName()), c));
    }
}

