/*
 * Decompiled with CFR 0.152.
 */
package dev.scheibelhofer.crypto.provider;

import dev.scheibelhofer.crypto.provider.JctProvider;
import dev.scheibelhofer.crypto.provider.NullPrivateKey;
import dev.scheibelhofer.crypto.provider.PemKeystoreException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

class Pem {
    static final String BEGIN = "-----BEGIN";
    static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    static final String BEGIN_ENCRYPTED_PRIVATE_KEY = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    static final String END_ENCRYPTED_PRIVATE_KEY = "-----END ENCRYPTED PRIVATE KEY-----";
    static final String END = "-----END";

    Pem() {
    }

    static class CertificateEntry
    extends Entry {
        X509Certificate certificate;

        CertificateEntry(String alias) {
            super(Entry.Type.certificate, alias);
        }

        CertificateEntry(String alias, X509Certificate certificate) {
            this(alias);
            this.certificate = certificate;
            try {
                this.encoding = certificate.getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new PemKeystoreException("failed encoding certificate", e);
            }
        }

        @Override
        void initFromEncoding(byte[] encoding) {
            super.initFromEncoding(encoding);
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                this.certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(encoding));
            }
            catch (Exception e) {
                throw new PemKeystoreException("failed decoding certificate", e);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CertificateEntry other = (CertificateEntry)obj;
            return !(this.certificate == null ? other.certificate != null : !this.certificate.equals(other.certificate));
        }
    }

    static class EncryptedPrivateKeyEntry
    extends Entry {
        EncryptedPrivateKeyInfo encryptedPrivateKey;
        PrivateKey privateKey;

        EncryptedPrivateKeyEntry(String alias) {
            super(Entry.Type.encryptedPrivateKey, alias);
        }

        @Override
        void initFromEncoding(byte[] encoding) {
            super.initFromEncoding(encoding);
            try {
                this.encryptedPrivateKey = new EncryptedPrivateKeyInfo(encoding);
            }
            catch (IOException e) {
                throw new PemKeystoreException("failed decoding encrypted private key", e);
            }
        }

        void decryptPrivateKey(char[] password) throws NoSuchAlgorithmException {
            try {
                PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
                AlgorithmParameters algParams = this.encryptedPrivateKey.getAlgParameters();
                String pbes2Name = algParams.toString();
                SecretKeyFactory skf = SecretKeyFactory.getInstance(pbes2Name);
                SecretKey pbeKey = skf.generateSecret(pbeKeySpec);
                Cipher cipher = Cipher.getInstance(pbes2Name);
                cipher.init(2, (Key)pbeKey, algParams);
                PKCS8EncodedKeySpec keySpec = this.encryptedPrivateKey.getKeySpec(cipher);
                KeyFactory kf = KeyFactory.getInstance(keySpec.getAlgorithm());
                this.privateKey = kf.generatePrivate(keySpec);
            }
            catch (Exception e) {
                throw new PemKeystoreException("error decrypting private key", e);
            }
        }
    }

    static class PrivateKeyEntry
    extends Entry {
        PrivateKey privateKey;

        PrivateKeyEntry(String alias) {
            super(Entry.Type.privateKey, alias);
        }

        PrivateKeyEntry(String alias, PrivateKey privateKey) {
            this(alias);
            this.privateKey = privateKey;
            this.encoding = privateKey.getEncoded();
        }

        @Override
        void initFromEncoding(byte[] encoding) {
            super.initFromEncoding(encoding);
            try {
                PKCS8EncodedKeySpec spec = this.createPkcs8KeySpec(encoding);
                KeyFactory kf = KeyFactory.getInstance(spec.getAlgorithm());
                this.privateKey = kf.generatePrivate(spec);
            }
            catch (Exception e) {
                throw new PemKeystoreException("failed decoding private key entry", e);
            }
        }

        private PKCS8EncodedKeySpec createPkcs8KeySpec(byte[] encoding) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException {
            AlgorithmParameters nullAlgorithmParam = AlgorithmParameters.getInstance("0.1", JctProvider.getInstance());
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(nullAlgorithmParam, encoding);
            Cipher nullCipher = Cipher.getInstance("null", JctProvider.getInstance());
            nullCipher.init(2, new NullPrivateKey());
            return epki.getKeySpec(nullCipher);
        }
    }

    static class UnknownEntry
    extends Entry {
        String pemBeginLine;

        UnknownEntry(String alias, String pemBeginLine) {
            super(Entry.Type.unknown, alias);
            this.pemBeginLine = pemBeginLine;
        }
    }

    static class Entry {
        Type type;
        byte[] encoding;
        String alias;

        Entry(Type type) {
            this.type = type;
        }

        Entry(Type type, String alias) {
            this.type = type;
            this.alias = alias;
        }

        Entry(Type type, byte[] encoding) {
            this.type = type;
            this.encoding = encoding;
        }

        void initFromEncoding(byte[] encoding) {
            this.encoding = encoding;
        }

        static enum Type {
            privateKey,
            certificate,
            encryptedPrivateKey,
            unknown;

        }
    }
}

