/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.vertexai;

import com.google.cloud.vertexai.VertexAI;
import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.generativeai.preview.GenerativeModel;
import com.google.cloud.vertexai.generativeai.preview.ResponseHandler;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.vertexai.ContentsMapper;
import dev.langchain4j.model.vertexai.StreamingChatResponseBuilder;
import java.io.IOException;
import java.util.List;

public class VertexAiGeminiStreamingChatModel
implements StreamingChatLanguageModel {
    private final GenerativeModel generativeModel;
    private final GenerationConfig generationConfig;

    public VertexAiGeminiStreamingChatModel(String project, String location, String modelName, Float temperature, Integer maxOutputTokens, Integer topK, Float topP) {
        try (VertexAI vertexAI = new VertexAI(ValidationUtils.ensureNotBlank((String)project, (String)"project"), ValidationUtils.ensureNotBlank((String)location, (String)"location"), new String[0]);){
            this.generativeModel = new GenerativeModel(ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName"), vertexAI);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        GenerationConfig.Builder generationConfigBuilder = GenerationConfig.newBuilder();
        if (temperature != null) {
            generationConfigBuilder.setTemperature(temperature.floatValue());
        }
        if (maxOutputTokens != null) {
            generationConfigBuilder.setMaxOutputTokens(maxOutputTokens.intValue());
        }
        if (topK != null) {
            generationConfigBuilder.setTopK((float)topK.intValue());
        }
        if (topP != null) {
            generationConfigBuilder.setTopP(topP.floatValue());
        }
        this.generationConfig = generationConfigBuilder.build();
    }

    public VertexAiGeminiStreamingChatModel(GenerativeModel generativeModel, GenerationConfig generationConfig) {
        this.generativeModel = (GenerativeModel)ValidationUtils.ensureNotNull((Object)generativeModel, (String)"generativeModel");
        this.generationConfig = (GenerationConfig)ValidationUtils.ensureNotNull((Object)generationConfig, (String)"generationConfig");
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        List<Content> contents = ContentsMapper.map(messages);
        StreamingChatResponseBuilder responseBuilder = new StreamingChatResponseBuilder();
        try {
            this.generativeModel.generateContentStream(contents, this.generationConfig).stream().forEach(partialResponse -> {
                responseBuilder.append((GenerateContentResponse)partialResponse);
                handler.onNext(ResponseHandler.getText((GenerateContentResponse)partialResponse));
            });
            handler.onComplete(responseBuilder.build());
        }
        catch (Exception exception) {
            handler.onError((Throwable)exception);
        }
    }

    public static VertexAiGeminiStreamingChatModelBuilder builder() {
        return new VertexAiGeminiStreamingChatModelBuilder();
    }

    public static class VertexAiGeminiStreamingChatModelBuilder {
        private String project;
        private String location;
        private String modelName;
        private Float temperature;
        private Integer maxOutputTokens;
        private Integer topK;
        private Float topP;

        VertexAiGeminiStreamingChatModelBuilder() {
        }

        public VertexAiGeminiStreamingChatModelBuilder project(String project) {
            this.project = project;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder location(String location) {
            this.location = location;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        public VertexAiGeminiStreamingChatModel build() {
            return new VertexAiGeminiStreamingChatModel(this.project, this.location, this.modelName, this.temperature, this.maxOutputTokens, this.topK, this.topP);
        }

        public String toString() {
            return "VertexAiGeminiStreamingChatModel.VertexAiGeminiStreamingChatModelBuilder(project=" + this.project + ", location=" + this.location + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", maxOutputTokens=" + this.maxOutputTokens + ", topK=" + this.topK + ", topP=" + this.topP + ")";
        }
    }
}

