/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.milvus;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.milvus.MilvusMetadataFilterMapper;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.param.MetricType;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.FlushParam;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class CollectionRequestBuilder {
    CollectionRequestBuilder() {
    }

    static FlushParam buildFlushRequest(String collectionName) {
        return FlushParam.newBuilder().withCollectionNames(Collections.singletonList(collectionName)).build();
    }

    static HasCollectionParam buildHasCollectionRequest(String collectionName) {
        return HasCollectionParam.newBuilder().withCollectionName(collectionName).build();
    }

    static DropCollectionParam buildDropCollectionRequest(String collectionName) {
        return DropCollectionParam.newBuilder().withCollectionName(collectionName).build();
    }

    static InsertParam buildInsertRequest(String collectionName, List<InsertParam.Field> fields) {
        return InsertParam.newBuilder().withCollectionName(collectionName).withFields(fields).build();
    }

    static LoadCollectionParam buildLoadCollectionInMemoryRequest(String collectionName) {
        return LoadCollectionParam.newBuilder().withCollectionName(collectionName).build();
    }

    static SearchParam buildSearchRequest(String collectionName, List<Float> vector, Filter filter, int maxResults, MetricType metricType, ConsistencyLevelEnum consistencyLevel) {
        SearchParam.Builder builder = SearchParam.newBuilder().withCollectionName(collectionName).withVectors(Collections.singletonList(vector)).withVectorFieldName("vector").withTopK(Integer.valueOf(maxResults)).withMetricType(metricType).withConsistencyLevel(consistencyLevel).withOutFields(Arrays.asList("id", "text", "metadata"));
        if (filter != null) {
            builder.withExpr(MilvusMetadataFilterMapper.map(filter));
        }
        return builder.build();
    }

    static QueryParam buildQueryRequest(String collectionName, List<String> rowIds, ConsistencyLevelEnum consistencyLevel) {
        return QueryParam.newBuilder().withCollectionName(collectionName).withExpr(CollectionRequestBuilder.buildQueryExpression(rowIds)).withConsistencyLevel(consistencyLevel).withOutFields(Collections.singletonList("vector")).build();
    }

    private static String buildQueryExpression(List<String> rowIds) {
        return rowIds.stream().map(id -> String.format("%s == '%s'", "id", id)).collect(Collectors.joining(" || "));
    }
}

