/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.localai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.embedding.EmbeddingRequest;
import dev.ai4j.openai4j.embedding.EmbeddingResponse;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.localai.spi.LocalAiEmbeddingModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class LocalAiEmbeddingModel
implements EmbeddingModel {
    private final OpenAiClient client;
    private final String modelName;
    private final Integer maxRetries;

    public LocalAiEmbeddingModel(String baseUrl, String modelName, Duration timeout, Integer maxRetries, Boolean logRequests, Boolean logResponses) {
        timeout = timeout == null ? Duration.ofSeconds(60L) : timeout;
        maxRetries = maxRetries == null ? 3 : maxRetries;
        this.client = OpenAiClient.builder().openAiApiKey("ignored").baseUrl(ValidationUtils.ensureNotBlank((String)baseUrl, (String)"baseUrl")).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).logRequests(logRequests).logResponses(logResponses).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.maxRetries = maxRetries;
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List texts = textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
        EmbeddingRequest request = EmbeddingRequest.builder().input(texts).model(this.modelName).build();
        EmbeddingResponse response = (EmbeddingResponse)RetryUtils.withRetry(() -> (EmbeddingResponse)this.client.embedding(request).execute(), (int)this.maxRetries);
        List embeddings = response.data().stream().map(openAiEmbedding -> Embedding.from((List)openAiEmbedding.embedding())).collect(Collectors.toList());
        return Response.from(embeddings);
    }

    public static LocalAiEmbeddingModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(LocalAiEmbeddingModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            LocalAiEmbeddingModelBuilderFactory factory = (LocalAiEmbeddingModelBuilderFactory)iterator.next();
            return (LocalAiEmbeddingModelBuilder)factory.get();
        }
        return new LocalAiEmbeddingModelBuilder();
    }

    public static class LocalAiEmbeddingModelBuilder {
        private String baseUrl;
        private String modelName;
        private Duration timeout;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;

        public LocalAiEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public LocalAiEmbeddingModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public LocalAiEmbeddingModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public LocalAiEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public LocalAiEmbeddingModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public LocalAiEmbeddingModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public LocalAiEmbeddingModel build() {
            return new LocalAiEmbeddingModel(this.baseUrl, this.modelName, this.timeout, this.maxRetries, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "LocalAiEmbeddingModel.LocalAiEmbeddingModelBuilder(baseUrl=" + this.baseUrl + ", modelName=" + this.modelName + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

