/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.filter.logical;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.logical.Or;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class OrTest {
    @Mock
    Filter mockFilterTrue;
    @Mock
    Filter mockFilterFalse;

    OrTest() {
    }

    @Test
    void shouldReturnTrueWhenLeftIsTrue() {
        Mockito.when((Object)this.mockFilterTrue.test(Mockito.any())).thenReturn((Object)true);
        Or or = new Or(this.mockFilterTrue, this.mockFilterFalse);
        Assertions.assertThat((boolean)or.test(new Object())).isTrue();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockFilterFalse});
    }

    @Test
    void shouldReturnTrueWhenRightIsTrue() {
        Mockito.when((Object)this.mockFilterTrue.test(Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.mockFilterFalse.test(Mockito.any())).thenReturn((Object)false);
        Or or = new Or(this.mockFilterFalse, this.mockFilterTrue);
        Assertions.assertThat((boolean)or.test(new Object())).isTrue();
    }

    @Test
    void shouldReturnFalseWhenBothAreFalse() {
        Mockito.when((Object)this.mockFilterFalse.test(Mockito.any())).thenReturn((Object)false);
        Or or = new Or(this.mockFilterFalse, this.mockFilterFalse);
        Assertions.assertThat((boolean)or.test(new Object())).isFalse();
    }

    @Test
    void equalsMethodShouldReturnTrueForNonDistinctObjects() {
        Or or1 = new Or(this.mockFilterTrue, this.mockFilterFalse);
        Or or2 = new Or(this.mockFilterTrue, this.mockFilterFalse);
        Assertions.assertThat((Object)or1).isEqualTo((Object)or2);
    }

    @Test
    void equalsAndHashCode() {
        Or orFilter = new Or(this.mockFilterTrue, this.mockFilterFalse);
        Or sameOrFilter = new Or(this.mockFilterTrue, this.mockFilterFalse);
        ((ObjectAssert)Assertions.assertThat((Object)orFilter).isEqualTo((Object)sameOrFilter)).hasSameHashCodeAs((Object)sameOrFilter);
    }

    @Test
    void toStringMethodShouldReturnExpectedValue() {
        Or or = new Or(this.mockFilterTrue, this.mockFilterFalse);
        Assertions.assertThat((Object)or).hasToString("Or(left=" + String.valueOf(this.mockFilterTrue) + ", right=" + String.valueOf(this.mockFilterFalse) + ")");
    }

    @Test
    void shouldHandleNullInput() {
        Mockito.when((Object)this.mockFilterTrue.test(null)).thenReturn((Object)true);
        Or or = new Or(this.mockFilterTrue, this.mockFilterFalse);
        Assertions.assertThat((boolean)or.test(null)).isTrue();
    }

    @Test
    void shouldThrowExceptionWhenConstructorReceivesNullLeftFilter() {
        AssertionsForClassTypes.assertThatThrownBy(() -> new Or(null, this.mockFilterFalse)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowExceptionWhenConstructorReceivesNullRightFilter() {
        AssertionsForClassTypes.assertThatThrownBy(() -> new Or(this.mockFilterTrue, null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowExceptionWhenConstructorReceivesBothFiltersNull() {
        AssertionsForClassTypes.assertThatThrownBy(() -> new Or(null, null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldNotEqualWithDifferentFilterOrder() {
        Or or1 = new Or(this.mockFilterTrue, this.mockFilterFalse);
        Or or2 = new Or(this.mockFilterFalse, this.mockFilterTrue);
        Assertions.assertThat((Object)or1).isNotEqualTo((Object)or2);
    }

    @Test
    void shouldNotEqualNull() {
        Or or = new Or(this.mockFilterTrue, this.mockFilterFalse);
        Assertions.assertThat((Object)or).isNotEqualTo(null);
    }

    @Test
    void shouldNotEqualDifferentClass() {
        Or or = new Or(this.mockFilterTrue, this.mockFilterFalse);
        Assertions.assertThat((Object)or).isNotEqualTo((Object)"not an Or filter");
    }
}

