/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.filter.comparison;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.store.embedding.filter.comparison.ContainsString;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ContainsStringTest {
    ContainsStringTest() {
    }

    @Test
    void shouldReturnFalseWhenNotMetadata() {
        ContainsString containsString = new ContainsString("key", "value");
        Assertions.assertThat((boolean)containsString.test((Object)"notMetadata")).isFalse();
    }

    @Test
    void shouldReturnFalseWhenKeyNotFound() {
        ContainsString containsString = new ContainsString("key", "value");
        Metadata metadata = new Metadata(Map.of());
        Assertions.assertThat((boolean)containsString.test((Object)metadata)).isFalse();
    }

    @Test
    void shouldReturnTrueWhenContains() {
        ContainsString containsString = new ContainsString("key", "value");
        Metadata metadata = new Metadata(Map.of("key", "foovaluebar"));
        Assertions.assertThat((boolean)containsString.test((Object)metadata)).isTrue();
    }

    @Test
    void shouldReturnFalseWhenNotContains() {
        ContainsString containsString = new ContainsString("key", "value");
        Metadata metadata = new Metadata(Map.of("key", "foobar"));
        Assertions.assertThat((boolean)containsString.test((Object)metadata)).isFalse();
    }

    @Test
    void shouldThrowIllegalArgumentExceptionWhenTypeMismatch() {
        ContainsString containsString = new ContainsString("key", "value");
        Metadata metadata = new Metadata(Map.of("key", 42));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> containsString.test((Object)metadata)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Type mismatch: actual value of metadata key \"key\" (42) has type java.lang.Integer, while it is expected to be a string");
    }

    @Test
    void shouldReturnFalseWhenCaseMismatch() {
        ContainsString containsString = new ContainsString("key", "VALUE");
        Metadata metadata = new Metadata(Map.of("key", "testvalue123"));
        Assertions.assertThat((boolean)containsString.test((Object)metadata)).isFalse();
    }

    @Test
    void shouldHandleEmptySearchString() {
        ContainsString containsString = new ContainsString("key", "");
        Metadata metadata = new Metadata(Map.of("key", "any string"));
        Assertions.assertThat((boolean)containsString.test((Object)metadata)).isTrue();
    }

    @Test
    void shouldHandleBothEmpty() {
        ContainsString containsString = new ContainsString("key", "");
        Metadata metadata = new Metadata(Map.of("key", ""));
        Assertions.assertThat((boolean)containsString.test((Object)metadata)).isTrue();
    }

    @Test
    void shouldThrowWhenMetadataValueIsDouble() {
        ContainsString containsString = new ContainsString("key", "value");
        Metadata metadata = new Metadata(Map.of("key", 3.14));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> containsString.test((Object)metadata)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Type mismatch").hasMessageContaining("java.lang.Double");
    }
}

