/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.request;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ChatRequestTest {
    ChatRequestTest() {
    }

    @Test
    void should_keep_backward_compatibility() {
        UserMessage userMessage = UserMessage.from((String)"hi");
        ToolSpecification toolSpecification = ToolSpecification.builder().name("tool").build();
        ResponseFormat responseFormat = ResponseFormat.JSON;
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).toolSpecifications(new ToolSpecification[]{toolSpecification}).responseFormat(responseFormat).build();
        Assertions.assertThat((List)chatRequest.messages()).containsExactly((Object[])new ChatMessage[]{userMessage});
        Assertions.assertThat((List)chatRequest.toolSpecifications()).containsExactly((Object[])new ToolSpecification[]{toolSpecification});
        Assertions.assertThat((Object)chatRequest.responseFormat()).isEqualTo((Object)responseFormat);
    }

    @Test
    void should_set_messages_and_request_parameters() {
        UserMessage userMessage = UserMessage.from((String)"hi");
        ToolSpecification toolSpecification = ToolSpecification.builder().name("tool").build();
        ResponseFormat responseFormat = ResponseFormat.JSON;
        ChatRequestParameters parameters = ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{toolSpecification}).responseFormat(responseFormat).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).parameters(parameters).build();
        Assertions.assertThat((List)chatRequest.messages()).containsExactly((Object[])new ChatMessage[]{userMessage});
        Assertions.assertThat((Object)chatRequest.parameters()).isEqualTo((Object)parameters);
        Assertions.assertThat((List)chatRequest.toolSpecifications()).containsExactly((Object[])new ToolSpecification[]{toolSpecification});
        Assertions.assertThat((Object)chatRequest.responseFormat()).isEqualTo((Object)responseFormat);
    }

    @Test
    void should_fail_when_both_request_parameters_and_response_format_are_set() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"hi")}).parameters(DefaultChatRequestParameters.EMPTY).responseFormat(ResponseFormat.JSON).build()).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set both 'parameters' and 'responseFormat' on ChatRequest");
    }

    @Test
    void should_fail_when_both_request_parameters_and_toolSpecifications_are_set() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"hi")}).parameters(DefaultChatRequestParameters.EMPTY).toolSpecifications(new ToolSpecification[]{ToolSpecification.builder().name("tool").build()}).build()).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set both 'parameters' and 'toolSpecifications' on ChatRequest");
    }

    @Test
    void should_create_chat_request_with_multiple_messages() {
        UserMessage firstMessage = UserMessage.from((String)"Hello");
        UserMessage secondMessage = UserMessage.from((String)"How are you?");
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{firstMessage, secondMessage}).build();
        Assertions.assertThat((List)chatRequest.messages()).containsExactly((Object[])new ChatMessage[]{firstMessage, secondMessage});
    }

    @Test
    void should_create_chat_request_with_multiple_tool_specifications() {
        ToolSpecification tool1 = ToolSpecification.builder().name("tool1").build();
        ToolSpecification tool2 = ToolSpecification.builder().name("tool2").build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"hi")}).toolSpecifications(new ToolSpecification[]{tool1, tool2}).build();
        Assertions.assertThat((List)chatRequest.toolSpecifications()).containsExactly((Object[])new ToolSpecification[]{tool1, tool2});
    }

    @Test
    void should_create_chat_request_with_only_parameters() {
        ChatRequestParameters parameters = ChatRequestParameters.builder().responseFormat(ResponseFormat.JSON).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"hi")}).parameters(parameters).build();
        Assertions.assertThat((Object)chatRequest.parameters()).isEqualTo((Object)parameters);
        Assertions.assertThat((Object)chatRequest.responseFormat()).isEqualTo((Object)ResponseFormat.JSON);
    }

    @Test
    void should_handle_null_response_format() {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"hi")}).responseFormat(null).build();
        Assertions.assertThat((Object)chatRequest.responseFormat()).isNull();
    }

    @Test
    void should_fail_when_messages_is_null() {
        Assertions.assertThatThrownBy(() -> ChatRequest.builder().messages((ChatMessage[])((UserMessage[])null)).build()).isExactlyInstanceOf(NullPointerException.class);
    }

    @Test
    void should_preserve_order_of_messages() {
        UserMessage first = UserMessage.from((String)"first");
        UserMessage second = UserMessage.from((String)"second");
        UserMessage third = UserMessage.from((String)"third");
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{first, second, third}).build();
        Assertions.assertThat((List)chatRequest.messages()).containsExactly((Object[])new ChatMessage[]{first, second, third});
    }

    @Test
    void should_preserve_order_of_tool_specifications() {
        ToolSpecification toolA = ToolSpecification.builder().name("toolA").build();
        ToolSpecification toolB = ToolSpecification.builder().name("toolB").build();
        ToolSpecification toolC = ToolSpecification.builder().name("toolC").build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"hi")}).toolSpecifications(new ToolSpecification[]{toolA, toolB, toolC}).build();
        Assertions.assertThat((List)chatRequest.toolSpecifications()).containsExactly((Object[])new ToolSpecification[]{toolA, toolB, toolC});
    }

    @Test
    void should_handle_empty_tool_specifications_array() {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"hi")}).toolSpecifications(new ToolSpecification[0]).build();
        Assertions.assertThat((List)chatRequest.toolSpecifications()).isEmpty();
    }

    @Test
    void should_fail_when_both_parameters_and_response_format_are_non_null() {
        ChatRequestParameters parameters = ChatRequestParameters.builder().build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"hi")}).parameters(parameters).responseFormat(ResponseFormat.JSON).build()).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set both 'parameters' and 'responseFormat' on ChatRequest");
    }

    @Test
    void should_fail_when_both_parameters_and_tool_specifications_are_non_null() {
        ChatRequestParameters parameters = ChatRequestParameters.builder().build();
        ToolSpecification tool = ToolSpecification.builder().name("tool").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"hi")}).parameters(parameters).toolSpecifications(new ToolSpecification[]{tool}).build()).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set both 'parameters' and 'toolSpecifications' on ChatRequest");
    }
}

