/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.data.MapEntry;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

class ChatModelListenerTest {
    ChatModelListenerTest() {
    }

    @Test
    void should_call_listeners_in_order_of_declaration() {
        ChatModelListener listener1 = (ChatModelListener)Mockito.spy((Object)new SuccessfulListener());
        ChatModelListener listener2 = (ChatModelListener)Mockito.spy((Object)new SuccessfulListener());
        TestChatModel model = new TestChatModel(List.of(listener1, listener2));
        model.chat("hi");
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{listener1, listener2});
        ((ChatModelListener)inOrder.verify((Object)listener1)).onRequest((ChatModelRequestContext)ArgumentMatchers.any());
        ((ChatModelListener)inOrder.verify((Object)listener2)).onRequest((ChatModelRequestContext)ArgumentMatchers.any());
        ((ChatModelListener)inOrder.verify((Object)listener1)).onResponse((ChatModelResponseContext)ArgumentMatchers.any());
        ((ChatModelListener)inOrder.verify((Object)listener2)).onResponse((ChatModelResponseContext)ArgumentMatchers.any());
        inOrder.verifyNoMoreInteractions();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener1, listener2});
    }

    @Test
    void should_ignore_exceptions_thrown_by_listeners() {
        ChatModelListener failingListener = (ChatModelListener)Mockito.spy((Object)new FailingListener());
        ChatModelListener successfulListener = (ChatModelListener)Mockito.spy((Object)new SuccessfulListener());
        TestChatModel model = new TestChatModel(List.of(failingListener, successfulListener));
        Assertions.assertThatNoException().isThrownBy(() -> model.chat("hi"));
        ((ChatModelListener)Mockito.verify((Object)failingListener)).onRequest((ChatModelRequestContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)failingListener)).onResponse((ChatModelResponseContext)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{failingListener});
        ((ChatModelListener)Mockito.verify((Object)successfulListener)).onRequest((ChatModelRequestContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)successfulListener)).onResponse((ChatModelResponseContext)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{successfulListener});
    }

    @Test
    void should_pass_attributes_from_one_listener_to_another() {
        ChatModelListener listener1 = (ChatModelListener)Mockito.spy((Object)new ChatModelListener(){

            public void onRequest(ChatModelRequestContext requestContext) {
                requestContext.attributes().put("my-attribute", "my-value");
            }
        });
        ChatModelListener listener2 = (ChatModelListener)Mockito.spy((Object)new ChatModelListener(){

            public void onResponse(ChatModelResponseContext responseContext) {
                Assertions.assertThat((Map)responseContext.attributes()).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"my-attribute", (Object)"my-value")});
            }
        });
        TestChatModel model = new TestChatModel(List.of(listener1, listener2));
        model.chat("hi");
        ((ChatModelListener)Mockito.verify((Object)listener2)).onResponse((ChatModelResponseContext)ArgumentMatchers.any());
    }

    @Test
    void should_call_onError_when_doChat_throws_exception() {
        ChatModelListener listener = (ChatModelListener)Mockito.spy((Object)new SuccessfulListener());
        TestChatModel model = new TestChatModel(List.of(listener)){

            @Override
            public ChatResponse doChat(ChatRequest chatRequest) {
                throw new RuntimeException("Chat model failed");
            }
        };
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> model.chat("hi")).isInstanceOf(RuntimeException.class)).hasMessage("Chat model failed");
        ((ChatModelListener)Mockito.verify((Object)listener)).onRequest((ChatModelRequestContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)listener)).onError((ChatModelErrorContext)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    void should_handle_empty_listeners_list() {
        TestChatModel model = new TestChatModel(List.of());
        Assertions.assertThatNoException().isThrownBy(() -> model.chat("hi"));
    }

    @Test
    void should_handle_null_listeners_list() {
        TestChatModel model = new TestChatModel(null);
        Assertions.assertThatNoException().isThrownBy(() -> model.chat("hi"));
    }

    @Test
    void should_continue_calling_listeners_even_when_some_fail_in_onError() {
        ChatModelListener failingListener = (ChatModelListener)Mockito.spy((Object)new FailingListener());
        ChatModelListener successfulListener = (ChatModelListener)Mockito.spy((Object)new SuccessfulListener());
        TestChatModel model = new TestChatModel(List.of(failingListener, successfulListener)){

            @Override
            public ChatResponse doChat(ChatRequest chatRequest) {
                throw new RuntimeException("Chat model failed");
            }
        };
        AssertionsForClassTypes.assertThatThrownBy(() -> model.chat("hi")).hasMessage("Chat model failed");
        ((ChatModelListener)Mockito.verify((Object)failingListener)).onRequest((ChatModelRequestContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)failingListener)).onError((ChatModelErrorContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)successfulListener)).onRequest((ChatModelRequestContext)ArgumentMatchers.any());
        ((ChatModelListener)Mockito.verify((Object)successfulListener)).onError((ChatModelErrorContext)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{failingListener, successfulListener});
    }

    @Test
    void should_maintain_attributes_across_request_and_error() {
        ChatModelListener listener1 = (ChatModelListener)Mockito.spy((Object)new ChatModelListener(){

            public void onRequest(ChatModelRequestContext requestContext) {
                requestContext.attributes().put("test-key", "test-value");
            }
        });
        ChatModelListener listener2 = (ChatModelListener)Mockito.spy((Object)new ChatModelListener(){

            public void onError(ChatModelErrorContext errorContext) {
                Assertions.assertThat((Map)errorContext.attributes()).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"test-key", (Object)"test-value")});
            }
        });
        TestChatModel model = new TestChatModel(List.of(listener1, listener2)){

            @Override
            public ChatResponse doChat(ChatRequest chatRequest) {
                throw new RuntimeException("Test error");
            }
        };
        AssertionsForClassTypes.assertThatThrownBy(() -> model.chat("hi"));
        ((ChatModelListener)Mockito.verify((Object)listener2)).onError((ChatModelErrorContext)ArgumentMatchers.any());
    }

    static class SuccessfulListener
    implements ChatModelListener {
        SuccessfulListener() {
        }

        public void onRequest(ChatModelRequestContext requestContext) {
        }

        public void onResponse(ChatModelResponseContext responseContext) {
        }

        public void onError(ChatModelErrorContext errorContext) {
        }
    }

    static class TestChatModel
    implements ChatModel {
        private final List<ChatModelListener> listeners;

        TestChatModel(List<ChatModelListener> listeners) {
            this.listeners = listeners;
        }

        public List<ChatModelListener> listeners() {
            return this.listeners;
        }

        public ChatResponse doChat(ChatRequest chatRequest) {
            return ChatResponse.builder().aiMessage(AiMessage.from((String)"hi")).build();
        }
    }

    static class FailingListener
    implements ChatModelListener {
        FailingListener() {
        }

        public void onRequest(ChatModelRequestContext requestContext) {
            throw new RuntimeException("something went wrong in onRequest()");
        }

        public void onResponse(ChatModelResponseContext responseContext) {
            throw new RuntimeException("something went wrong in onResponse()");
        }

        public void onError(ChatModelErrorContext errorContext) {
            throw new RuntimeException("something went wrong in onError()");
        }
    }
}

