/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.audio;

import dev.langchain4j.data.audio.Audio;
import dev.langchain4j.model.audio.AudioTranscriptionRequest;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AudioTranscriptionRequestTest {
    AudioTranscriptionRequestTest() {
    }

    @Test
    void should_create_request_with_audio_only() {
        Audio audio = Audio.builder().binaryData("test audio".getBytes()).mimeType("audio/wav").build();
        AudioTranscriptionRequest request = AudioTranscriptionRequest.builder().audio(audio).build();
        Assertions.assertThat((Object)request.audio()).isEqualTo((Object)audio);
        Assertions.assertThat((String)request.prompt()).isNull();
        Assertions.assertThat((String)request.language()).isNull();
        Assertions.assertThat((Double)request.temperature()).isNull();
    }

    @Test
    void should_create_request_with_all_parameters() {
        Audio audio = Audio.builder().binaryData("test audio".getBytes()).mimeType("audio/wav").build();
        String prompt = "Test prompt";
        String language = "en";
        Double temperature = 0.5;
        AudioTranscriptionRequest request = AudioTranscriptionRequest.builder().audio(audio).prompt(prompt).language(language).temperature(temperature).build();
        Assertions.assertThat((Object)request.audio()).isEqualTo((Object)audio);
        Assertions.assertThat((String)request.prompt()).isEqualTo(prompt);
        Assertions.assertThat((String)request.language()).isEqualTo(language);
        Assertions.assertThat((Double)request.temperature()).isEqualTo(temperature);
    }

    @Test
    void should_create_request_with_builder_audio_parameter() {
        Audio audio = Audio.builder().binaryData("test audio".getBytes()).mimeType("audio/wav").build();
        AudioTranscriptionRequest request = AudioTranscriptionRequest.builder((Audio)audio).prompt("Test prompt").build();
        Assertions.assertThat((Object)request.audio()).isEqualTo((Object)audio);
        Assertions.assertThat((String)request.prompt()).isEqualTo("Test prompt");
    }

    @Test
    void should_throw_exception_when_audio_is_null() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AudioTranscriptionRequest.builder().build()).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Audio must be provided");
    }

    @Test
    void should_handle_zero_temperature() {
        Audio audio = Audio.builder().binaryData("test audio".getBytes()).mimeType("audio/wav").build();
        AudioTranscriptionRequest request = AudioTranscriptionRequest.builder().audio(audio).temperature(Double.valueOf(0.0)).build();
        Assertions.assertThat((Double)request.temperature()).isEqualTo(0.0);
    }

    @Test
    void should_handle_max_temperature() {
        Audio audio = Audio.builder().binaryData("test audio".getBytes()).mimeType("audio/wav").build();
        AudioTranscriptionRequest request = AudioTranscriptionRequest.builder().audio(audio).temperature(Double.valueOf(1.0)).build();
        Assertions.assertThat((Double)request.temperature()).isEqualTo(1.0);
    }

    @Test
    void should_handle_empty_string_parameters() {
        Audio audio = Audio.builder().binaryData("test audio".getBytes()).mimeType("audio/wav").build();
        AudioTranscriptionRequest request = AudioTranscriptionRequest.builder().audio(audio).prompt("").language("").build();
        Assertions.assertThat((String)request.prompt()).isEqualTo("");
        Assertions.assertThat((String)request.language()).isEqualTo("");
    }

    @Test
    void should_handle_various_language_codes() {
        Audio audio = Audio.builder().binaryData("test audio".getBytes()).mimeType("audio/wav").build();
        AudioTranscriptionRequest request1 = AudioTranscriptionRequest.builder().audio(audio).language("en").build();
        AudioTranscriptionRequest request2 = AudioTranscriptionRequest.builder().audio(audio).language("fr").build();
        AudioTranscriptionRequest request3 = AudioTranscriptionRequest.builder().audio(audio).language("es-ES").build();
        Assertions.assertThat((String)request1.language()).isEqualTo("en");
        Assertions.assertThat((String)request2.language()).isEqualTo("fr");
        Assertions.assertThat((String)request3.language()).isEqualTo("es-ES");
    }

    @Test
    void should_handle_long_prompt() {
        Audio audio = Audio.builder().binaryData("test audio".getBytes()).mimeType("audio/wav").build();
        String longPrompt = "This is a very long prompt that contains multiple sentences. It should be used to guide the transcription process. The prompt can contain specific terminology or context.";
        AudioTranscriptionRequest request = AudioTranscriptionRequest.builder().audio(audio).prompt(longPrompt).build();
        Assertions.assertThat((String)request.prompt()).isEqualTo(longPrompt);
    }
}

