/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import dev.langchain4j.internal.ValidationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

class ValidationUtilsTest
implements WithAssertions {
    ValidationUtilsTest() {
    }

    @Test
    void ensure_eq() {
        ValidationUtils.ensureEq((Object)1, (Object)1, (String)"test", (Object[])new Object[0]);
        ValidationUtils.ensureEq((Object)"abc", (Object)"abc", (String)"test", (Object[])new Object[0]);
        ValidationUtils.ensureEq(null, null, (String)"test", (Object[])new Object[0]);
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureEq((Object)1, (Object)2, (String)"test %d", (Object[])new Object[]{7})).withMessageContaining("test 7");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureEq((Object)1, null, (String)"test", (Object[])new Object[0])).withMessageContaining("test");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureEq(null, (Object)1, (String)"test", (Object[])new Object[0])).withMessageContaining("test");
    }

    @Test
    void ensure_not_null() {
        Object obj = new Object();
        this.assertThat(ValidationUtils.ensureNotNull((Object)obj, (String)"test")).isSameAs(obj);
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotNull(null, (String)"test")).withMessage("test cannot be null");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotNull(null, (String)"test %d", (Object[])new Object[]{7})).withMessage("test 7");
    }

    @Test
    void ensure_not_empty_string() {
        String str = " abc  ";
        this.assertThat(ValidationUtils.ensureNotEmpty((String)str, (String)"test")).isSameAs((Object)str);
        str = "";
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotEmpty((String)str, (String)"test")).withMessageContaining("test cannot be null or empty");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotEmpty((String)null, (String)"test")).withMessageContaining("test cannot be null or empty");
    }

    @Test
    void ensure_not_empty_collection() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Object());
        this.assertThat((List)ValidationUtils.ensureNotEmpty(list, (String)"test")).isSameAs(list);
        list = new ArrayList();
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotEmpty((Collection)list, (String)"test")).withMessageContaining("test cannot be null or empty");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotEmpty((Collection)null, (String)"test")).withMessageContaining("test cannot be null or empty");
    }

    @Test
    void ensure_not_empty_array() {
        Object[] array = new Object[]{new Object()};
        this.assertThat(ValidationUtils.ensureNotEmpty((Object[])array, (String)"test")).isSameAs((Object)array);
        array = new Object[]{};
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotEmpty((Object[])array, (String)"test")).withMessageContaining("test cannot be null or empty");
        array = new Object[]{};
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotEmpty((Object[])array, (String)"%s", (Object[])new Object[]{"Parameterized type has no type arguments."})).withMessageContaining("Parameterized type has no type arguments.");
        array = null;
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotEmpty((Object[])array, (String)"test")).withMessageContaining("test cannot be null or empty");
    }

    @Test
    void ensure_not_empty_map() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(new Object(), new Object());
        this.assertThat(ValidationUtils.ensureNotEmpty(map, (String)"test")).isSameAs(map);
        map = new HashMap();
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotEmpty((Map)map, (String)"test")).withMessageContaining("test cannot be null or empty");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotEmpty((Map)null, (String)"test")).withMessageContaining("test cannot be null or empty");
    }

    @Test
    void ensure_not_blank() {
        String str = " abc  ";
        this.assertThat(ValidationUtils.ensureNotBlank((String)str, (String)"test")).isSameAs((Object)str);
        str = "  ";
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotBlank((String)str, (String)"test")).withMessageContaining("test cannot be null or blank");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureNotBlank(null, (String)"test")).withMessageContaining("test cannot be null or blank");
    }

    @Test
    void ensure_true() {
        ValidationUtils.ensureTrue((boolean)true, (String)"test");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureTrue((boolean)false, (String)"test")).withMessageContaining("test");
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 0x7FFFFFFF})
    void should_not_throw_when_positive(Integer i) {
        ValidationUtils.ensureNotNegative((Integer)i, (String)"integer");
    }

    @ParameterizedTest
    @NullSource
    @ValueSource(ints={-2147483648, -1})
    void should_throw_when_negative(Integer i) {
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> ValidationUtils.ensureNotNegative((Integer)i, (String)"integer")).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("integer must not be negative, but is: " + i);
    }

    @ParameterizedTest
    @ValueSource(ints={1, 0x7FFFFFFF})
    void should_not_throw_when_greater_than_0(Integer i) {
        ValidationUtils.ensureGreaterThanZero((Integer)i, (String)"integer");
    }

    @ParameterizedTest
    @NullSource
    @ValueSource(ints={-2147483648, 0})
    void should_throw_when_when_not_greater_than_0(Integer i) {
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> ValidationUtils.ensureGreaterThanZero((Integer)i, (String)"integer")).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("integer must be greater than zero, but is: " + i);
    }

    @ParameterizedTest
    @ValueSource(doubles={0.0, 0.5, 1.0})
    void should_not_throw_when_between(Double d) {
        ValidationUtils.ensureBetween((Double)d, (double)0.0, (double)1.0, (String)"test");
    }

    @ParameterizedTest
    @NullSource
    @ValueSource(doubles={-0.1, 1.1})
    void should_throw_when_not_between(Double d) {
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> ValidationUtils.ensureBetween((Double)d, (double)0.0, (double)1.0, (String)"test")).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("test must be between 0.0 and 1.0, but is: " + d);
    }

    @Test
    void ensure_between_int() {
        ValidationUtils.ensureBetween((Integer)1, (int)0, (int)1, (String)"test");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureBetween((Integer)2, (int)0, (int)1, (String)"test")).withMessageContaining("test must be between 0 and 1, but is: 2");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureBetween((Integer)-1, (int)0, (int)1, (String)"test")).withMessageContaining("test must be between 0 and 1, but is: -1");
    }

    @Test
    void ensure_between_long() {
        ValidationUtils.ensureBetween((Long)1L, (long)0L, (long)1L, (String)"test");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureBetween((Long)2L, (long)0L, (long)1L, (String)"test")).withMessageContaining("test must be between 0 and 1, but is: 2");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ValidationUtils.ensureBetween((Long)-1L, (long)0L, (long)1L, (String)"test")).withMessageContaining("test must be between 0 and 1, but is: -1");
    }
}

