/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.internal.JacksonJsonCodec;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.collections.ContainKt;
import io.kotest.matchers.types.MatchersKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.kotlin.MockingKt;
import org.mockito.kotlin.UseConstructor;
import org.mockito.kotlin.VerificationKt;
import org.mockito.listeners.InvocationListener;
import org.mockito.mock.SerializableMode;
import org.mockito.stubbing.Answer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007J\b\u0010\t\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/langchain4j/internal/JacksonJsonCodecTest;", "", "()V", "subject", "Ldev/langchain4j/internal/JacksonJsonCodec;", "Should create with provided ObjectMapper", "", "Should deserialize Kotlin data classes", "Should find and register modules on startup", "Should serialize Kotlin data classes", "ServiceResponse", "langchain4j-core"})
@SourceDebugExtension(value={"SMAP\nJacksonJsonCodecTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JacksonJsonCodecTest.kt\ndev/langchain4j/internal/JacksonJsonCodecTest\n+ 2 Mocking.kt\norg/mockito/kotlin/MockingKt\n*L\n1#1,61:1\n54#2,29:62\n*S KotlinDebug\n*F\n+ 1 JacksonJsonCodecTest.kt\ndev/langchain4j/internal/JacksonJsonCodecTest\n*L\n24#1:62,29\n*E\n"})
public final class JacksonJsonCodecTest {
    @NotNull
    private final JacksonJsonCodec subject = new JacksonJsonCodec();

    @Test
    public final void Should create with provided ObjectMapper() {
        KClass[] extraInterfaces$iv = null;
        String name$iv = null;
        Object spiedInstance$iv = null;
        Answer defaultAnswer$iv = null;
        boolean serializable$iv = false;
        SerializableMode serializableMode$iv = null;
        boolean verboseLogging$iv = false;
        InvocationListener[] invocationListeners$iv = null;
        boolean stubOnly$iv = false;
        UseConstructor useConstructor$iv = null;
        Object outerInstance$iv = null;
        boolean lenient$iv = false;
        boolean $i$f$mock = false;
        Object object = Mockito.mock(ObjectMapper.class, (MockSettings)MockingKt.withSettings(extraInterfaces$iv, name$iv, spiedInstance$iv, defaultAnswer$iv, (boolean)serializable$iv, serializableMode$iv, (boolean)verboseLogging$iv, invocationListeners$iv, (boolean)stubOnly$iv, useConstructor$iv, outerInstance$iv, (boolean)lenient$iv));
        Intrinsics.checkNotNull((Object)object);
        ObjectMapper providedMapper = (ObjectMapper)object;
        JacksonJsonCodec codec = new JacksonJsonCodec(providedMapper);
        MatchersKt.shouldBeSameInstanceAs((Object)codec.getObjectMapper(), (Object)providedMapper);
        Object[] objectArray = new Object[]{providedMapper};
        VerificationKt.verifyNoInteractions((Object[])objectArray);
    }

    @Test
    public final void Should find and register modules on startup() {
        Set registeredModuleIds = this.subject.getObjectMapper().getRegisteredModuleIds();
        Intrinsics.checkNotNull((Object)registeredModuleIds);
        ContainKt.shouldContain((Iterable)registeredModuleIds, (Object)"com.fasterxml.jackson.module.kotlin.KotlinModule");
        ContainKt.shouldContain((Iterable)registeredModuleIds, (Object)"langchain4j-module");
    }

    @Test
    public final void Should deserialize Kotlin data classes() {
        ServiceResponse result = (ServiceResponse)this.subject.fromJson("{\"status\": \"ok\", \"is_success\": true}", ServiceResponse.class);
        ShouldKt.shouldBe((Object)result, (Object)new ServiceResponse("ok", true));
    }

    @Test
    public final void Should serialize Kotlin data classes() {
        String jsonString = this.subject.toJson((Object)new ServiceResponse("ok", true));
        Intrinsics.checkNotNull((Object)jsonString);
        io.kotest.assertions.json.MatchersKt.shouldEqualSpecifiedJson((String)jsonString, (String)"{\n  \"status\" : \"ok\",\n  \"is_success\" : true\n}");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Ldev/langchain4j/internal/JacksonJsonCodecTest$ServiceResponse;", "", "status", "", "isSuccess", "", "(Ljava/lang/String;Z)V", "()Z", "getStatus", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "langchain4j-core"})
    public static final class ServiceResponse {
        @NotNull
        private final String status;
        private final boolean isSuccess;

        public ServiceResponse(@NotNull String status, @JsonProperty(value="is_success") boolean isSuccess) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.status = status;
            this.isSuccess = isSuccess;
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        public final boolean isSuccess() {
            return this.isSuccess;
        }

        @NotNull
        public final String component1() {
            return this.status;
        }

        public final boolean component2() {
            return this.isSuccess;
        }

        @NotNull
        public final ServiceResponse copy(@NotNull String status, @JsonProperty(value="is_success") boolean isSuccess) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return new ServiceResponse(status, isSuccess);
        }

        public static /* synthetic */ ServiceResponse copy$default(ServiceResponse serviceResponse, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = serviceResponse.status;
            }
            if ((n & 2) != 0) {
                bl = serviceResponse.isSuccess;
            }
            return serviceResponse.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "ServiceResponse(status=" + this.status + ", isSuccess=" + this.isSuccess + ")";
        }

        public int hashCode() {
            int result = this.status.hashCode();
            result = result * 31 + Boolean.hashCode(this.isSuccess);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServiceResponse)) {
                return false;
            }
            ServiceResponse serviceResponse = (ServiceResponse)other;
            if (!Intrinsics.areEqual((Object)this.status, (Object)serviceResponse.status)) {
                return false;
            }
            return this.isSuccess == serviceResponse.isSuccess;
        }
    }
}

