/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.neo4j;

import dev.langchain4j.community.store.embedding.neo4j.Neo4jEmbeddingStore;
import dev.langchain4j.community.store.embedding.neo4j.Neo4jEmbeddingStoreIngestor;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.EmbeddingStore;

public class ParentChildGraphIngestor
extends Neo4jEmbeddingStoreIngestor {
    public ParentChildGraphIngestor(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Neo4jEmbeddingStoreIngestor.Builder {
        private static final String DEFAULT_RETRIEVAL = "MATCH (node)<-[:HAS_CHILD]-(parent)\nWITH parent, collect(node.text) AS chunks, max(score) AS score\nRETURN parent.text + reduce(r = \"\", c in chunks | r + \"\\n\\n\" + c) AS text,\n       score,\n       properties(parent) AS metadata\nORDER BY score DESC\nLIMIT $maxResults";
        private static final String DEFAULT_PARENT_QUERY = "UNWIND $rows AS row\nMATCH (p:ParentChunk {parentId: $parentId})\nCREATE (p)-[:HAS_CHILD]->(u:%1$s {%2$s: row.%2$s})\nSET u += row.%3$s\nWITH row, u\nCALL db.create.setNodeVectorProperty(u, $embeddingProperty, row.%4$s)\nRETURN count(*)";
        private static final String DEFAULT_CHUNK_CREATION_QUERY = "CREATE (:ParentChunk $metadata)";

        private EmbeddingStore<TextSegment> defaultEmbeddingStore() {
            return Neo4jEmbeddingStore.builder().driver(this.driver).retrievalQuery(DEFAULT_RETRIEVAL).entityCreationQuery(DEFAULT_PARENT_QUERY).label("Child").indexName("child_embedding_index").dimension(384).build();
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ParentChildGraphIngestor build() {
            this.query = (String)Utils.getOrDefault((Object)this.query, (Object)DEFAULT_CHUNK_CREATION_QUERY);
            this.embeddingStore = (EmbeddingStore)Utils.getOrDefault((Object)this.embeddingStore, this.defaultEmbeddingStore());
            return new ParentChildGraphIngestor(this);
        }
    }
}

