/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.DocumentTransformer;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.data.segment.TextSegmentTransformer;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.EmbeddingStoreIngestor;
import dev.langchain4j.store.embedding.IngestionResult;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class ParentChildEmbeddingStoreIngestor
extends EmbeddingStoreIngestor {
    private static final Logger log = LoggerFactory.getLogger(ParentChildEmbeddingStoreIngestor.class);
    private final DocumentTransformer documentTransformer;
    private final DocumentSplitter documentSplitter;
    protected TextSegmentTransformer textSegmentTransformer;
    protected TextSegmentTransformer childTextSegmentTransformer;
    private final EmbeddingModel embeddingModel;
    protected EmbeddingStore<TextSegment> embeddingStore;
    private final DocumentSplitter documentChildSplitter;

    public ParentChildEmbeddingStoreIngestor(DocumentTransformer documentTransformer, DocumentSplitter documentSplitter, TextSegmentTransformer textSegmentTransformer, TextSegmentTransformer childTextSegmentTransformer, EmbeddingModel embeddingModel, EmbeddingStore<TextSegment> embeddingStore, DocumentSplitter documentChildSplitter) {
        super(documentTransformer, documentSplitter, textSegmentTransformer, embeddingModel, embeddingStore);
        this.documentTransformer = documentTransformer;
        this.documentSplitter = documentSplitter;
        this.textSegmentTransformer = textSegmentTransformer;
        this.childTextSegmentTransformer = childTextSegmentTransformer;
        this.embeddingModel = embeddingModel;
        this.embeddingStore = embeddingStore;
        this.documentChildSplitter = documentChildSplitter;
    }

    public IngestionResult ingest(List<Document> documents) {
        List segments;
        log.debug("Starting to ingest {} documents", (Object)documents.size());
        if (this.documentTransformer != null) {
            documents = this.documentTransformer.transformAll(documents);
            log.debug("Documents were transformed into {} documents", (Object)documents.size());
        }
        if (this.documentSplitter != null) {
            segments = this.documentSplitter.splitAll(documents);
            log.debug("Documents were split into {} text segments", (Object)segments.size());
        } else {
            segments = documents.stream().map(Document::toTextSegment).collect(Collectors.toList());
        }
        if (this.textSegmentTransformer != null) {
            segments = this.textSegmentTransformer.transformAll(segments);
            log.debug("Text segments were transformed into {} text segments", (Object)documents.size());
        }
        if (this.documentChildSplitter != null) {
            TokenUsage totalUsage = new TokenUsage();
            for (TextSegment segment : segments) {
                Document parentDoc = Document.from((String)segment.text(), (Metadata)segment.metadata());
                List<TextSegment> childSegments = this.documentChildSplitter.split(parentDoc).stream().map(i -> {
                    assert (this.childTextSegmentTransformer != null);
                    return this.childTextSegmentTransformer.transform(i);
                }).toList();
                Response embeddingsResponse = this.embeddingModel.embedAll(childSegments);
                this.embeddingStore.addAll((List)embeddingsResponse.content(), childSegments);
                totalUsage = totalUsage.add(embeddingsResponse.tokenUsage());
            }
            return new IngestionResult(totalUsage);
        }
        log.debug("Starting to embed {} text segments", (Object)segments.size());
        Response embeddingsResponse = this.embeddingModel.embedAll(segments);
        log.debug("Finished embedding {} text segments", (Object)segments.size());
        log.debug("Starting to store {} text segments into the embedding store", (Object)segments.size());
        this.embeddingStore.addAll((List)embeddingsResponse.content(), segments);
        log.debug("Finished storing {} text segments into the embedding store", (Object)segments.size());
        return new IngestionResult(embeddingsResponse.tokenUsage());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<B extends Builder<B>>
    extends EmbeddingStoreIngestor.Builder {
        public DocumentTransformer documentTransformer;
        public DocumentSplitter documentSplitter;
        public DocumentSplitter documentChildSplitter;
        public TextSegmentTransformer textSegmentTransformer;
        public TextSegmentTransformer childTextSegmentTransformer;
        public EmbeddingModel embeddingModel;
        public EmbeddingStore<TextSegment> embeddingStore;

        protected B self() {
            return (B)((Object)this);
        }

        public B childTextSegmentTransformer(TextSegmentTransformer childTextSegmentTransformer) {
            this.childTextSegmentTransformer = childTextSegmentTransformer;
            return this.self();
        }

        public B documentChildSplitter(DocumentSplitter documentChildSplitter) {
            this.documentChildSplitter = documentChildSplitter;
            return this.self();
        }

        public B documentTransformer(DocumentTransformer documentTransformer) {
            this.documentTransformer = documentTransformer;
            return this.self();
        }

        public B documentSplitter(DocumentSplitter documentSplitter) {
            this.documentSplitter = documentSplitter;
            return this.self();
        }

        public B textSegmentTransformer(TextSegmentTransformer textSegmentTransformer) {
            this.textSegmentTransformer = textSegmentTransformer;
            return this.self();
        }

        public B embeddingModel(EmbeddingModel embeddingModel) {
            this.embeddingModel = embeddingModel;
            return this.self();
        }

        public B embeddingStore(EmbeddingStore<TextSegment> embeddingStore) {
            this.embeddingStore = embeddingStore;
            return this.self();
        }

        public ParentChildEmbeddingStoreIngestor build() {
            return new ParentChildEmbeddingStoreIngestor(this.documentTransformer, this.documentSplitter, this.textSegmentTransformer, this.childTextSegmentTransformer, this.embeddingModel, this.embeddingStore, this.documentChildSplitter);
        }
    }
}

