/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.rag.content.aggregator.strategy;

import dev.langchain4j.community.rag.content.aggregator.strategy.EmbeddingStrategy;
import dev.langchain4j.community.rag.content.aggregator.strategy.GenerateEmbeddings;
import dev.langchain4j.community.rag.content.aggregator.strategy.HybridEmbeddings;
import dev.langchain4j.community.rag.content.aggregator.strategy.UseExistingEmbeddings;
import dev.langchain4j.community.rag.content.util.EmbeddingMetadataUtils;
import dev.langchain4j.rag.content.Content;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddingStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(EmbeddingStrategyFactory.class);

    public static EmbeddingStrategy createStrategy(List<Content> contents, boolean forceGeneration) {
        if (forceGeneration) {
            log.debug("Force generation enabled - using GenerateEmbeddings strategy");
            return new GenerateEmbeddings();
        }
        if (contents.isEmpty()) {
            log.debug("Empty content list - using GenerateEmbeddings strategy");
            return new GenerateEmbeddings();
        }
        long embeddedCount = contents.stream().mapToLong(content -> EmbeddingStrategyFactory.hasEmbedding(content) ? 1L : 0L).sum();
        if (embeddedCount == 0L) {
            log.debug("No embeddings found - using GenerateEmbeddings strategy");
            return new GenerateEmbeddings();
        }
        if (embeddedCount == (long)contents.size()) {
            log.debug("All contents have embeddings - using UseExistingEmbeddings strategy");
            return new UseExistingEmbeddings();
        }
        log.debug("Mixed embedding availability ({}/{}) - using HybridEmbeddings strategy", (Object)embeddedCount, (Object)contents.size());
        return new HybridEmbeddings();
    }

    private static boolean hasEmbedding(Content content) {
        return EmbeddingMetadataUtils.extractDocumentEmbedding(content.textSegment()) != null;
    }
}

