/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.data.document.graph;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.Experimental;
import dev.langchain4j.community.data.document.graph.GraphEdge;
import dev.langchain4j.community.data.document.graph.GraphNode;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Objects;
import java.util.Set;

@Experimental
public class GraphDocument {
    private final Set<GraphNode> nodes;
    private final Set<GraphEdge> relationships;
    private final Document source;

    public GraphDocument(Set<GraphNode> nodes, Set<GraphEdge> relationships, Document source) {
        this.nodes = Utils.copyIfNotNull((Set)((Set)ValidationUtils.ensureNotNull(nodes, (String)"nodes")));
        this.relationships = Utils.copyIfNotNull((Set)((Set)ValidationUtils.ensureNotNull(relationships, (String)"relationships")));
        this.source = (Document)ValidationUtils.ensureNotNull((Object)source, (String)"source");
    }

    @JsonProperty
    public Set<GraphNode> nodes() {
        return this.nodes;
    }

    @JsonProperty
    public Set<GraphEdge> relationships() {
        return this.relationships;
    }

    @JsonProperty
    public Document source() {
        return this.source;
    }

    public static GraphDocument from(Set<GraphNode> nodes, Set<GraphEdge> relationships, Document source) {
        return new GraphDocument(nodes, relationships, source);
    }

    public static GraphDocument from(Document source) {
        return new GraphDocument(Set.of(), Set.of(), source);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GraphDocument that = (GraphDocument)object;
        return Objects.equals(this.nodes, that.nodes) && Objects.equals(this.relationships, that.relationships) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.relationships, this.source);
    }

    public String toString() {
        return "GraphDocument{nodes=" + String.valueOf(this.nodes) + ", relationships=" + String.valueOf(this.relationships) + ", source=" + String.valueOf(this.source) + "}";
    }
}

