/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.Choice;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsFinishReason;
import com.azure.ai.openai.models.FunctionCall;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.azure.InternalAzureOpenAiHelper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Collections;
import java.util.List;

class AzureOpenAiStreamingResponseBuilder {
    private final StringBuffer contentBuilder = new StringBuffer();
    private final StringBuffer toolNameBuilder = new StringBuffer();
    private final StringBuffer toolArgumentsBuilder = new StringBuffer();
    private volatile CompletionsFinishReason finishReason;
    private final Integer inputTokenCount;

    public AzureOpenAiStreamingResponseBuilder(Integer inputTokenCount) {
        this.inputTokenCount = inputTokenCount;
    }

    public void append(ChatCompletions completions) {
        ChatResponseMessage delta;
        if (completions == null) {
            return;
        }
        List choices = completions.getChoices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        ChatChoice chatCompletionChoice = (ChatChoice)choices.get(0);
        if (chatCompletionChoice == null) {
            return;
        }
        CompletionsFinishReason finishReason = chatCompletionChoice.getFinishReason();
        if (finishReason != null) {
            this.finishReason = finishReason;
        }
        if ((delta = chatCompletionChoice.getDelta()) == null) {
            return;
        }
        String content = delta.getContent();
        if (content != null) {
            this.contentBuilder.append(content);
            return;
        }
        FunctionCall functionCall = delta.getFunctionCall();
        if (functionCall != null) {
            if (functionCall.getName() != null) {
                this.toolNameBuilder.append(functionCall.getName());
            }
            if (functionCall.getArguments() != null) {
                this.toolArgumentsBuilder.append(functionCall.getArguments());
            }
        }
    }

    public void append(Completions completions) {
        String token;
        if (completions == null) {
            return;
        }
        List choices = completions.getChoices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        Choice completionChoice = (Choice)choices.get(0);
        if (completionChoice == null) {
            return;
        }
        CompletionsFinishReason completionsFinishReason = completionChoice.getFinishReason();
        if (completionsFinishReason != null) {
            this.finishReason = completionsFinishReason;
        }
        if ((token = completionChoice.getText()) != null) {
            this.contentBuilder.append(token);
        }
    }

    public Response<AiMessage> build(Tokenizer tokenizer, boolean forcefulToolExecution) {
        String content = this.contentBuilder.toString();
        if (!content.isEmpty()) {
            return Response.from((Object)AiMessage.from((String)content), (TokenUsage)this.tokenUsage(content, tokenizer), (FinishReason)InternalAzureOpenAiHelper.finishReasonFrom(this.finishReason));
        }
        String toolName = this.toolNameBuilder.toString();
        if (!toolName.isEmpty()) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(toolName).arguments(this.toolArgumentsBuilder.toString()).build();
            return Response.from((Object)AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest}), (TokenUsage)this.tokenUsage(toolExecutionRequest, tokenizer, forcefulToolExecution), (FinishReason)InternalAzureOpenAiHelper.finishReasonFrom(this.finishReason));
        }
        return null;
    }

    private TokenUsage tokenUsage(String content, Tokenizer tokenizer) {
        if (tokenizer == null) {
            return null;
        }
        int outputTokenCount = tokenizer.estimateTokenCountInText(content);
        return new TokenUsage(this.inputTokenCount, Integer.valueOf(outputTokenCount));
    }

    private TokenUsage tokenUsage(ToolExecutionRequest toolExecutionRequest, Tokenizer tokenizer, boolean forcefulToolExecution) {
        if (tokenizer == null) {
            return null;
        }
        int outputTokenCount = 0;
        outputTokenCount = forcefulToolExecution ? (outputTokenCount += tokenizer.estimateTokenCountInForcefulToolExecutionRequest(toolExecutionRequest)) : tokenizer.estimateTokenCountInToolExecutionRequests(Collections.singletonList(toolExecutionRequest));
        return new TokenUsage(this.inputTokenCount, Integer.valueOf(outputTokenCount));
    }
}

