/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agentic.Agent;
import dev.langchain4j.agentic.agent.MissingArgumentException;
import dev.langchain4j.agentic.declarative.LoopCounter;
import dev.langchain4j.agentic.internal.A2AService;
import dev.langchain4j.agentic.internal.AgentExecutor;
import dev.langchain4j.agentic.internal.AgentInvocationArguments;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentSpecificationImpl;
import dev.langchain4j.agentic.internal.AgentSpecsProvider;
import dev.langchain4j.agentic.internal.MethodAgentInvoker;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.service.MemoryId;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public class AgentUtil {
    public static final String MEMORY_ID_ARG_NAME = "@MemoryId";
    public static final String AGENTIC_SCOPE_ARG_NAME = "@AgenticScope";
    public static final String LOOP_COUNTER_ARG_NAME = "@LoopCounter";
    private static final AtomicInteger AGENT_COUNTER = new AtomicInteger(0);

    private AgentUtil() {
    }

    public static String uniqueAgentName(String agentName) {
        return agentName + "$" + AGENT_COUNTER.incrementAndGet();
    }

    public static List<AgentExecutor> agentsToExecutors(Object ... agents) {
        return Stream.of(agents).map(AgentUtil::agentToExecutor).toList();
    }

    public static AgentExecutor agentToExecutor(Object agent) {
        AgentExecutor agentExecutor;
        if (agent instanceof AgentSpecification) {
            AgentSpecification agentSpecification = (AgentSpecification)agent;
            agentExecutor = AgentUtil.agentToExecutor(agentSpecification);
        } else {
            agentExecutor = AgentUtil.nonAiAgentToExecutor(agent);
        }
        return agentExecutor;
    }

    private static AgentExecutor nonAiAgentToExecutor(Object agent) {
        AgentInvoker agentInvoker;
        String description;
        Method agenticMethod = AgentUtil.validateAgentClass(agent.getClass());
        Agent annotation = agenticMethod.getAnnotation(Agent.class);
        String name = Utils.isNullOrBlank((String)annotation.name()) ? agenticMethod.getName() : annotation.name();
        String uniqueName = AgentUtil.uniqueAgentName(name);
        String string = description = Utils.isNullOrBlank((String)annotation.description()) ? annotation.value() : annotation.description();
        if (agent instanceof AgentSpecsProvider) {
            AgentSpecsProvider spec = (AgentSpecsProvider)agent;
            agentInvoker = new MethodAgentInvoker(agenticMethod, new AgentSpecificationImpl(name, uniqueName, spec.description(), spec.outputName(), spec.async(), x -> {}, x -> {}), List.of(new AgentArgument(agenticMethod.getParameterTypes()[0], spec.inputName())));
        } else {
            agentInvoker = AgentInvoker.fromMethod(new AgentSpecificationImpl(name, uniqueName, description, annotation.outputName(), annotation.async(), x -> {}, x -> {}), agenticMethod);
        }
        AgentInvoker agentInvoker2 = agentInvoker;
        return new AgentExecutor(agentInvoker2, agent);
    }

    public static AgentExecutor agentToExecutor(AgentSpecification agent) {
        for (Method method : agent.getClass().getMethods()) {
            Optional<AgentExecutor> executor;
            Optional<AgentExecutor> optional = executor = A2AService.get().isPresent() ? A2AService.get().methodToAgentExecutor(agent, method) : AgentUtil.methodToAgentExecutor(agent, method);
            if (!executor.isPresent()) continue;
            return executor.get();
        }
        throw new IllegalArgumentException("Agent executor not found");
    }

    public static Optional<Method> getAnnotatedMethodOnClass(Class<?> clazz, Class<? extends Annotation> annotation) {
        return Arrays.stream(clazz.getMethods()).filter(m -> m.isAnnotationPresent(annotation)).findFirst();
    }

    private static Optional<AgentExecutor> methodToAgentExecutor(AgentSpecification agent, Method method) {
        return Utils.getAnnotatedMethod((Method)method, Agent.class).map(agentMethod -> new AgentExecutor(AgentInvoker.fromMethod(agent, agentMethod), agent));
    }

    public static List<AgentArgument> argumentsFromMethod(Method method) {
        return Stream.of(method.getParameters()).map(p -> new AgentArgument(p.getType(), AgentUtil.parameterName(p))).toList();
    }

    private static String parameterName(Parameter p) {
        if (p.getAnnotation(MemoryId.class) != null) {
            return MEMORY_ID_ARG_NAME;
        }
        if (p.getAnnotation(LoopCounter.class) != null) {
            return LOOP_COUNTER_ARG_NAME;
        }
        if (AgenticScope.class.isAssignableFrom(p.getType())) {
            return AGENTIC_SCOPE_ARG_NAME;
        }
        return AgentInvoker.parameterName(p);
    }

    public static AgentInvocationArguments agentInvocationArguments(AgenticScope agenticScope, List<AgentArgument> agentArguments) throws MissingArgumentException {
        return AgentUtil.agentInvocationArguments(agenticScope, agentArguments, Map.of());
    }

    public static AgentInvocationArguments agentInvocationArguments(AgenticScope agenticScope, List<AgentArgument> agentArguments, Map<String, Object> additionalArgs) throws MissingArgumentException {
        HashMap<String, Object> namedArgs = new HashMap<String, Object>();
        Object[] positionalArgs = new Object[agentArguments.size()];
        int i = 0;
        for (AgentArgument arg : agentArguments) {
            String argName = arg.name();
            if (argName.equals(MEMORY_ID_ARG_NAME)) {
                positionalArgs[i++] = agenticScope.memoryId();
                continue;
            }
            if (argName.equals(AGENTIC_SCOPE_ARG_NAME)) {
                positionalArgs[i++] = agenticScope;
                continue;
            }
            if (additionalArgs.containsKey(argName)) {
                positionalArgs[i++] = additionalArgs.get(argName);
                continue;
            }
            Object argValue = AgentUtil.argumentFromAgenticScope(agenticScope, arg.type(), argName);
            positionalArgs[i++] = argValue;
            namedArgs.put(argName, argValue);
        }
        return new AgentInvocationArguments(namedArgs, positionalArgs);
    }

    public static Object argumentFromAgenticScope(AgenticScope agenticScope, Class<?> argType, String argName) {
        Object argValue = agenticScope.readState(argName);
        if (argValue == null) {
            throw new MissingArgumentException(argName);
        }
        Object parsedArgument = AgentUtil.parseArgument(argValue, argType);
        if (argValue != parsedArgument) {
            agenticScope.writeState(argName, parsedArgument);
        }
        return parsedArgument;
    }

    static Object parseArgument(Object argValue, Class<?> type) {
        if (argValue instanceof String) {
            String s = (String)argValue;
            return switch (type.getName()) {
                case "java.lang.String", "java.lang.Object" -> s;
                case "int", "java.lang.Integer" -> Integer.parseInt(s);
                case "long", "java.lang.Long" -> Long.parseLong(s);
                case "double", "java.lang.Double" -> Double.parseDouble(s);
                case "float", "java.lang.Float" -> Float.valueOf(Float.parseFloat(s));
                case "boolean", "java.lang.Boolean" -> Boolean.parseBoolean(s);
                default -> throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
            };
        }
        return argValue;
    }

    public static Method validateAgentClass(Class<?> agentServiceClass) {
        return AgentUtil.validateAgentClass(agentServiceClass, true);
    }

    public static Method validateAgentClass(Class<?> agentServiceClass, boolean failOnMissingAnnotation) {
        Method agentMethod = null;
        for (Method method : agentServiceClass.getMethods()) {
            if (!method.isAnnotationPresent(Agent.class)) continue;
            if (agentMethod != null) {
                throw new IllegalArgumentException("Multiple agent methods found in class: " + agentServiceClass.getName());
            }
            agentMethod = method;
        }
        if (agentMethod == null && failOnMissingAnnotation) {
            throw new IllegalArgumentException("No agent method found in class: " + agentServiceClass.getName());
        }
        return agentMethod;
    }

    public record AgentArgument(Class<?> type, String name) {
    }
}

