/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.matcher.persistent;

import dev.brachtendorf.jimagehash.datastructures.tree.Result;
import dev.brachtendorf.jimagehash.hash.Hash;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import dev.brachtendorf.jimagehash.matcher.TypedImageMatcher;
import dev.brachtendorf.jimagehash.matcher.persistent.ConsecutiveMatcher;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public abstract class PersistentImageMatcher
extends TypedImageMatcher
implements Serializable {
    private static final long serialVersionUID = 4656669336898685462L;
    private static final Logger LOGGER = Logger.getLogger(ConsecutiveMatcher.class.getSimpleName());
    protected boolean lockedState = false;
    protected HashMap<String, Hash> addedImageMap;

    protected PersistentImageMatcher() {
    }

    @Override
    public void addHashingAlgorithm(HashingAlgorithm algo, double threshold) {
        this.checkLockedState();
        super.addHashingAlgorithm(algo, threshold);
    }

    @Override
    public void addHashingAlgorithm(HashingAlgorithm algo, double threshold, boolean normalized) {
        this.checkLockedState();
        super.addHashingAlgorithm(algo, threshold, normalized);
    }

    @Override
    public void clearHashingAlgorithms() {
        this.checkLockedState();
        super.clearHashingAlgorithms();
    }

    public void addImage(File imageFile) throws IOException {
        this.addImage(imageFile.getAbsolutePath(), imageFile);
    }

    public void addImages(File ... imagesToAdd) throws IOException {
        for (File img : imagesToAdd) {
            this.addImage(img);
        }
    }

    public void addImage(String uniqueId, File imageFile) throws IOException {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("Please supply at least one hashing algorithm prior to invoking the match method");
        }
        if (!imageFile.isFile()) {
            throw new IllegalArgumentException("Please make sure you add an image to the matcher. Directories are not supported");
        }
        this.addImage(uniqueId, ImageIO.read(imageFile));
    }

    public void addImage(String uniqueId, BufferedImage image) {
        this.addImageInternal(uniqueId, image);
        this.lockedState = true;
    }

    protected abstract void addImageInternal(String var1, BufferedImage var2);

    public PriorityQueue<Result<String>> getMatchingImages(File image) throws IOException {
        return this.getMatchingImages(ImageIO.read(image));
    }

    public abstract PriorityQueue<Result<String>> getMatchingImages(BufferedImage var1);

    public void serializeState(File saveLocation) throws IOException {
        if (saveLocation.exists()) {
            LOGGER.warning("Output file already exists. Overwritting serizable file file");
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveLocation));){
            oos.writeObject(this);
        }
    }

    public static PersistentImageMatcher reconstructState(File saveLocation, boolean deleteSerFile) throws ClassNotFoundException, IOException {
        PersistentImageMatcher pImageMatcher;
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(saveLocation));){
            pImageMatcher = (PersistentImageMatcher)ois.readObject();
        }
        if (deleteSerFile) {
            saveLocation.delete();
        }
        return pImageMatcher;
    }

    protected void checkLockedState() {
        if (this.lockedState) {
            throw new IllegalStateException("Images have already been added to the matcher. Changing hashing algorithms would invalidate the internal state.");
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.steps);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.steps = (LinkedHashMap)ois.readObject();
    }
}

