/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.matcher.persistent;

import dev.brachtendorf.jimagehash.datastructures.tree.Result;
import dev.brachtendorf.jimagehash.datastructures.tree.binaryTree.BinaryTree;
import dev.brachtendorf.jimagehash.hash.Hash;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import dev.brachtendorf.jimagehash.matcher.TypedImageMatcher;
import dev.brachtendorf.jimagehash.matcher.persistent.PersitentBinaryTreeMatcher;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.PriorityQueue;

public class ConsecutiveMatcher
extends PersitentBinaryTreeMatcher {
    private static final long serialVersionUID = 831914616034052308L;

    public ConsecutiveMatcher(boolean cacheAddedHashes) {
        super(cacheAddedHashes);
    }

    @Override
    protected PriorityQueue<Result<String>> getMatchingImagesInternal(BufferedImage image, String uniqueId) {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("Please supply at least one hashing algorithm prior to invoking the match method");
        }
        PriorityQueue returnValues = null;
        for (Map.Entry entry : this.steps.entrySet()) {
            HashingAlgorithm algo = (HashingAlgorithm)entry.getKey();
            BinaryTree binTree = (BinaryTree)this.binTreeMap.get(algo);
            TypedImageMatcher.AlgoSettings settings = (TypedImageMatcher.AlgoSettings)entry.getValue();
            Hash needleHash = this.getHash(algo, uniqueId, image);
            int threshold = 0;
            if (settings.isNormalized()) {
                int hashLength = needleHash.getBitResolution();
                threshold = (int)Math.round(settings.getThreshold() * (double)hashLength);
            } else {
                threshold = (int)settings.getThreshold();
            }
            PriorityQueue temp = binTree.getElementsWithinHammingDistance(needleHash, threshold);
            if (returnValues == null) {
                returnValues = temp;
                continue;
            }
            temp.retainAll(returnValues);
            returnValues = temp;
        }
        return returnValues;
    }
}

