/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.matcher.categorize.supervised.randomForest;

import dev.brachtendorf.StringUtil;
import dev.brachtendorf.jimagehash.hash.FuzzyHash;
import dev.brachtendorf.jimagehash.hash.Hash;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import dev.brachtendorf.jimagehash.matcher.categorize.supervised.randomForest.TreeNode;
import java.awt.image.BufferedImage;

class InnerNode
extends TreeNode {
    private FuzzyHash internalHash;
    private HashingAlgorithm hasher;
    private double threshold;
    protected double quality;
    protected double qualityLeft;
    protected double qualityRight;
    protected TreeNode leftNode;
    protected TreeNode rightNode;

    protected InnerNode() {
    }

    public InnerNode(FuzzyHash internalHash, HashingAlgorithm hasher, double bestCutoff, double quality, double qualityLeft, double qualityRight) {
        this.internalHash = internalHash;
        this.hasher = hasher;
        this.threshold = bestCutoff;
        this.quality = quality;
        this.qualityLeft = qualityLeft;
        this.qualityRight = qualityRight;
    }

    @Override
    public int[] predictAgainstAll(BufferedImage bi) {
        Hash targetHash = this.hasher.hash(bi);
        double distance = this.internalHash.normalizedHammingDistance(targetHash);
        if (distance < this.threshold) {
            return this.leftNode.predictAgainstAll(bi);
        }
        return this.rightNode.predictAgainstAll(bi);
    }

    public String toString() {
        return "InnerNode [internalHash=" + this.internalHash + ", hasher=" + this.hasher + ", threshold=" + this.threshold + ", quality=" + this.quality + "]";
    }

    @Override
    public void printTree() {
        this.printTree(0);
    }

    @Override
    public void printTree(int depth) {
        System.out.println(StringUtil.multiplyChar((String)"\t", (int)depth) + this);
        this.leftNode.printTree(++depth);
        if (this.rightNode != null) {
            this.rightNode.printTree(depth);
        }
    }
}

