/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.matcher.categorize.supervised;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class LabeledImage
implements Comparable<LabeledImage> {
    protected String name;
    protected int category;
    protected BufferedImage bImage;

    public LabeledImage(int category, File f) {
        try {
            this.bImage = ImageIO.read(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.name = f.getName().substring(0, f.getName().lastIndexOf("."));
        this.category = category;
    }

    @Override
    public int compareTo(LabeledImage o) {
        return Integer.compare(this.category, o.category);
    }

    public String toString() {
        return "LabeledImage [name=" + this.name + ", category=" + this.category + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bImage == null ? 0 : this.bImage.hashCode());
        result = 31 * result + this.category;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabeledImage other = (LabeledImage)obj;
        if (this.bImage == null ? other.bImage != null : !this.bImage.equals(other.bImage)) {
            return false;
        }
        if (this.category != other.category) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getName() {
        return this.name;
    }

    public int getCategory() {
        return this.category;
    }

    public BufferedImage getbImage() {
        return this.bImage;
    }
}

