/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.matcher.categorize;

import dev.brachtendorf.datastructures.Pair;
import dev.brachtendorf.jimagehash.hash.FuzzyHash;
import dev.brachtendorf.jimagehash.hash.Hash;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import dev.brachtendorf.jimagehash.matcher.categorize.AbstractCategoricalMatcher;
import dev.brachtendorf.jimagehash.matcher.categorize.CategoricalImageMatcher;
import dev.brachtendorf.jimagehash.matcher.categorize.CategorizationResult;
import dev.brachtendorf.jimagehash.matcher.categorize.WeightedCategoricalMatcher;
import dev.brachtendorf.jimagehash.matcher.categorize.supervised.LabeledImage;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class CategoricalMatcher
extends AbstractCategoricalMatcher {
    private static final Logger LOGGER = Logger.getLogger(WeightedCategoricalMatcher.class.getSimpleName());
    protected Map<HashingAlgorithm, Map<Integer, FuzzyHash>> clusterHash = new HashMap<HashingAlgorithm, Map<Integer, FuzzyHash>>();
    protected Map<HashingAlgorithm, Map<FuzzyHash, Integer>> clusterReverseLookup = new HashMap<HashingAlgorithm, Map<FuzzyHash, Integer>>();
    protected Map<String, Map<HashingAlgorithm, Hash>> cachedHashes = new HashMap<String, Map<HashingAlgorithm, Hash>>();
    protected Map<Integer, DoubleSummaryStatistics> clusterQuality = new HashMap<Integer, DoubleSummaryStatistics>();
    protected boolean clusterRecomputed = false;
    protected TreeSet<Integer> categories = new TreeSet();
    protected Map<Integer, CategoricalImageMatcher> subCategoryMatcher = new HashMap<Integer, CategoricalImageMatcher>();
    protected double newCategoryThreshold;
    protected Set<Integer> categoriesAltered = new HashSet<Integer>();

    public CategoricalMatcher(double newAdditionThreshold) {
        this.newCategoryThreshold = newAdditionThreshold;
    }

    @Override
    public void recomputeCategories() {
        this.recomputeClusters(10);
    }

    protected boolean recomputeClusters(int maxIterations) {
        if (this.categoriesAltered.isEmpty()) {
            return false;
        }
        boolean globalChange = false;
        this.clusterPrecomputation();
        for (int iter = 0; iter < maxIterations; ++iter) {
            int totalUpdate = 0;
            boolean changed = false;
            HashMap<String, Pair<Integer, Hash[]>> newImageCategoryMap = new HashMap<String, Pair<Integer, Hash[]>>();
            HashSet<Integer> catTemp = new HashSet<Integer>();
            for (Map.Entry<String, Map<HashingAlgorithm, Hash>> entry : this.cachedHashes.entrySet()) {
                String uniqueId = entry.getKey();
                Map<HashingAlgorithm, Hash> hashesAsMap = entry.getValue();
                Hash[] hashes = new Hash[this.steps.size()];
                int i = 0;
                for (HashingAlgorithm hasher : this.steps) {
                    hashes[i++] = hashesAsMap.get(hasher);
                }
                int category = this.getCategory(iter, uniqueId, hashes, this.categoriesAltered);
                if (category == -1) {
                    System.out.println(category);
                }
                newImageCategoryMap.put(uniqueId, (Pair<Integer, Hash[]>)new Pair((Object)category, (Object)hashes));
                int oldCategory = (Integer)this.reverseImageCategoryMap.get(uniqueId);
                if (category == oldCategory) continue;
                changed = true;
                globalChange = true;
                ++totalUpdate;
                catTemp.add(category);
                catTemp.add(oldCategory);
            }
            this.updateCategories(newImageCategoryMap);
            this.categoriesAltered.clear();
            this.categoriesAltered.addAll(catTemp);
            LOGGER.fine("Recomputed cluster: " + iter + " Updated: " + totalUpdate);
            if (!changed) break;
        }
        this.clusterRecomputed = true;
        this.clusterPostcomputation();
        return globalChange;
    }

    protected void clusterPrecomputation() {
    }

    protected void clusterPostcomputation() {
    }

    protected int getCategory(int iter, String uniqueId, Hash[] hashes, Set<Integer> categoriesAltered) {
        return this.categorizeImage((String)uniqueId, (Hash[])hashes, categoriesAltered).category;
    }

    protected void updateCategories(Map<String, Pair<Integer, Hash[]>> newImageCategoryMap) {
        Map<Integer, FuzzyHash> hashes;
        this.reverseImageCategoryMap.clear();
        this.cachedImagesInCategory.clear();
        this.clusterQuality.clear();
        this.resetBitWeights();
        HashMap cachedHashClone = new HashMap();
        for (HashingAlgorithm hashingAlgorithm : this.steps) {
            hashes = this.clusterHash.get(hashingAlgorithm);
            HashMap<Integer, Hash> clonedHashes = new HashMap<Integer, Hash>();
            cachedHashClone.put(hashingAlgorithm, clonedHashes);
            for (int category : this.categories) {
                FuzzyHash bHash = hashes.get(category);
                clonedHashes.put(category, new Hash(bHash.getHashValue(), bHash.getBitResolution(), Integer.MAX_VALUE));
            }
        }
        for (Map.Entry entry : newImageCategoryMap.entrySet()) {
            String uniqueId = (String)entry.getKey();
            int category = (Integer)((Pair)entry.getValue()).getFirst();
            Hash[] hashes2 = (Hash[])((Pair)entry.getValue()).getSecond();
            this.addCategoricalImage(hashes2, category, uniqueId);
            this.reverseImageCategoryMap.put(uniqueId, category);
        }
        for (HashingAlgorithm hashingAlgorithm : this.steps) {
            hashes = this.clusterHash.get(hashingAlgorithm);
            Map clonedHashes = (Map)cachedHashClone.get(hashingAlgorithm);
            for (int category : this.categories) {
                FuzzyHash categoryBase = hashes.get(category);
                categoryBase.subtractFast((Hash)clonedHashes.get(category));
            }
        }
        this.cleanupEmptyCategories();
    }

    protected void cleanupEmptyCategories() {
        Iterator iter = this.cachedImagesInCategory.keySet().iterator();
        while (iter.hasNext()) {
            int category = (Integer)iter.next();
            if (!((List)this.cachedImagesInCategory.get(category)).isEmpty()) continue;
            this.cachedImagesInCategory.remove(category);
            for (HashingAlgorithm hasher : this.steps) {
                FuzzyHash removedHash = this.clusterHash.get(hasher).remove(category);
                this.clusterReverseLookup.get(hasher).remove(removedHash);
            }
            iter.remove();
        }
    }

    protected void resetBitWeights() {
        for (HashingAlgorithm hasher : this.steps) {
            Map<Integer, FuzzyHash> hashes = this.clusterHash.get(hasher);
            for (int category : this.categories) {
                hashes.get(category).reset();
            }
        }
    }

    @Override
    public boolean addHashingAlgorithm(HashingAlgorithm algo) {
        if (!this.steps.contains(algo)) {
            this.clusterHash.put(algo, new HashMap());
            this.clusterReverseLookup.put(algo, new HashMap());
        }
        return super.addHashingAlgorithm(algo);
    }

    public void addCategoricalImages(Collection<LabeledImage> images) {
        this.addCategoricalImages(images.toArray(new LabeledImage[images.size()]));
    }

    public void addCategoricalImages(LabeledImage ... images) {
        for (LabeledImage lImage : images) {
            this.addCategoricalImage(lImage);
        }
    }

    public double addCategoricalImage(LabeledImage labeledImage) {
        return this.addCategoricalImage(labeledImage.getbImage(), labeledImage.getCategory(), labeledImage.getName());
    }

    public double addCategoricalImage(BufferedImage bi, int category, String uniqueId) {
        int i = 0;
        Hash[] hashes = new Hash[this.steps.size()];
        for (HashingAlgorithm hashAlgorithm : this.steps) {
            Hash createdHash = hashAlgorithm.hash(bi);
            hashes[i++] = createdHash;
            if (this.cachedHashes.containsKey(uniqueId)) {
                this.cachedHashes.get(uniqueId).put(hashAlgorithm, createdHash);
                continue;
            }
            HashMap<HashingAlgorithm, Hash> hashMap = new HashMap<HashingAlgorithm, Hash>((int)((double)this.steps.size() / 0.75 + 1.0));
            hashMap.put(hashAlgorithm, createdHash);
            this.cachedHashes.put(uniqueId, hashMap);
        }
        return this.addCategoricalImage(hashes, category, uniqueId);
    }

    protected double addCategoricalImage(Hash[] hashes, int category, String uniqueId) {
        DoubleSummaryStatistics stats;
        double averageDistance = 0.0;
        int i = 0;
        for (HashingAlgorithm hashAlgorithm : this.steps) {
            Hash createdHash = hashes[i++];
            Map<Integer, FuzzyHash> categoryMap = this.clusterHash.get(hashAlgorithm);
            Map<FuzzyHash, Integer> reverseCategoryMap = this.clusterReverseLookup.get(hashAlgorithm);
            if (!categoryMap.containsKey(category)) {
                FuzzyHash fHash = new FuzzyHash();
                categoryMap.put(category, fHash);
                reverseCategoryMap.put(fHash, category);
                this.categories.add(category);
            }
            FuzzyHash cHash = this.clusterHash.get(hashAlgorithm).get(category);
            cHash.mergeFast(createdHash);
            averageDistance += this.computeDistanceToCluster(cHash, createdHash);
        }
        if (this.clusterQuality.containsKey(category)) {
            stats = this.clusterQuality.get(category);
        } else {
            stats = new DoubleSummaryStatistics();
            this.clusterQuality.put(category, stats);
        }
        double distance = averageDistance / (double)this.steps.size();
        stats.accept(distance);
        this.categoriesAltered.add(category);
        this.reverseImageCategoryMap.put(uniqueId, category);
        if (this.cachedImagesInCategory.containsKey(category)) {
            ((List)this.cachedImagesInCategory.get(category)).add(uniqueId);
        } else {
            ArrayList<String> uniqueIds = new ArrayList<String>();
            uniqueIds.add(uniqueId);
            this.cachedImagesInCategory.put(category, uniqueIds);
        }
        return distance;
    }

    protected double computeDistanceToCluster(FuzzyHash cluster, Hash imageHash) {
        return cluster.normalizedHammingDistanceFast(imageHash);
    }

    @Override
    public CategorizationResult categorizeImage(BufferedImage bi) {
        CategorizationResult catResult = this.categorizeImage(null, bi);
        if (this.subCategoryMatcher.containsKey(catResult.getCategory())) {
            catResult.addCategory(this.subCategoryMatcher.get(catResult.getCategory()).categorizeImage(bi));
            return catResult;
        }
        return catResult;
    }

    @Override
    protected CategorizationResult categorizeImage(String uniqueId, BufferedImage bi) {
        Hash[] hashes = new Hash[this.steps.size()];
        int j = 0;
        for (HashingAlgorithm hashAlgorithm : this.steps) {
            hashes[j] = hashAlgorithm.hash(bi);
            ++j;
        }
        return this.categorizeImage(uniqueId, hashes, this.categories);
    }

    protected CategorizationResult categorizeImage(String uniqueId, Hash[] hashes, Set<Integer> categoriesAltered) {
        double bestDistance = Double.MAX_VALUE;
        int bestCategory = -1;
        if (uniqueId != null && this.isCategorized(uniqueId)) {
            int oldCategory = this.getCategory(uniqueId);
            bestDistance = this.computeDistanceForCategory(hashes, oldCategory, bestDistance);
            bestCategory = oldCategory;
        }
        for (Integer category : categoriesAltered) {
            double hammingDistance;
            if (category == bestCategory || !((hammingDistance = this.computeDistanceForCategory(hashes, category, bestDistance)) < bestDistance)) continue;
            bestDistance = hammingDistance;
            bestCategory = category;
        }
        if (bestCategory == -1) {
            return new CategorizationResult(bestCategory, Double.MAX_VALUE);
        }
        double normalizedHammingDistance = bestDistance / (double)this.steps.size();
        return new CategorizationResult(bestCategory, normalizedHammingDistance);
    }

    protected double computeDistanceForCategory(Hash[] hashes, int category, double bestDistance) {
        double hammingDistance = 0.0;
        int j = 0;
        for (HashingAlgorithm hashAlgorithm : this.steps) {
            Map<Integer, FuzzyHash> categoricalAverageHash = this.clusterHash.get(hashAlgorithm);
            hammingDistance += categoricalAverageHash.get(category).normalizedHammingDistanceFast(hashes[j]);
            ++j;
        }
        return hammingDistance;
    }

    @Override
    public CategorizationResult categorizeImageAndAdd(BufferedImage bi, String uniqueId) {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("Please add a hashing algorithm before categorizing images");
        }
        CategorizationResult catResult = this.categorizeImage(uniqueId, bi);
        int category = catResult.getCategory();
        double distance = catResult.getQuality();
        if (distance > this.newCategoryThreshold) {
            category = this.categories.isEmpty() ? 0 : this.categories.last() + 1;
            assert (!this.categories.contains(category));
        }
        distance = this.addCategoricalImage(bi, category, uniqueId);
        catResult.category = category;
        catResult.qualityMeasurement = distance;
        if (this.subCategoryMatcher.containsKey(category)) {
            catResult.addCategory(this.subCategoryMatcher.get(category).categorizeImageAndAdd(bi, uniqueId));
        }
        return catResult;
    }

    @Override
    public List<Integer> getCategories() {
        ArrayList<Integer> categoriesAsList = new ArrayList<Integer>(this.categories);
        categoriesAsList.sort(null);
        return categoriesAsList;
    }

    public LinkedHashMap<Integer, Integer> getCategoriesSortedByImageCount() {
        List<Integer> categories = this.getCategories();
        LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < categories.size(); ++i) {
            int cat = categories.get(i);
            map.put(cat, this.getImageCountInCategory(categories.get(cat)));
        }
        Comparator comp = (c1, c2) -> ((Integer)c1.getValue()).compareTo((Integer)c2.getValue());
        return map.entrySet().stream().sorted(comp.reversed()).collect(Collectors.toMap(e -> (Integer)e.getKey(), e -> (Integer)e.getValue(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    public BufferedImage categoricalHashToImage(HashingAlgorithm hashAlgorithm, int category, int blockSize) {
        if (!this.categories.contains(category)) {
            throw new IllegalArgumentException("No entry for category: " + category + " found");
        }
        return this.clusterHash.get(hashAlgorithm).get(category).toImage(blockSize, hashAlgorithm);
    }

    public void printClusterInfo(int minImagesInCluster) {
        for (Map.Entry<Integer, DoubleSummaryStatistics> entry : this.clusterQuality.entrySet()) {
            if (entry.getValue().getCount() < (long)minImagesInCluster) continue;
            System.out.println("Category: " + entry.getKey() + " Average Distance: " + entry.getValue().getAverage());
        }
    }

    public double getAverageDistanceWithinCluster(int category) {
        return this.clusterQuality.get(category).getAverage();
    }

    public FuzzyHash getClusterAverageHash(HashingAlgorithm algorithm, int category) {
        return this.clusterHash.get(algorithm).get(category);
    }
}

