/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms.experimental;

import dev.brachtendorf.ArrayUtil;
import dev.brachtendorf.MathUtil;
import dev.brachtendorf.Require;
import dev.brachtendorf.graphics.ColorUtil;
import dev.brachtendorf.graphics.FastPixel;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashBuilder;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;
import javax.imageio.ImageIO;

public class HogHash
extends HashingAlgorithm {
    protected static final long serialVersionUID = 5353878339786219609L;
    protected int width;
    protected int height;
    protected int cellWidth;
    protected int xCells;
    protected int yCells;
    protected int numBins;

    public HogHash(int width, int height, int cellWidth, int numBins) {
        super(numBins);
        assert (width % cellWidth == 0);
        assert (height % cellWidth == 0);
        if (width % cellWidth != 0 || height % cellWidth != 0) {
            throw new IllegalArgumentException("Height and width have to be a multiple of cellWidth");
        }
        this.width = (Integer)Require.positiveValue((Number)width);
        this.height = (Integer)Require.positiveValue((Number)height);
        this.cellWidth = (Integer)Require.positiveValue((Number)cellWidth);
        this.numBins = (Integer)Require.positiveValue((Number)numBins);
        this.xCells = width / cellWidth;
        this.yCells = height / cellWidth;
    }

    public HogHash(int bitResolution) {
        super(bitResolution);
        int height;
        double estimatedLength;
        if (bitResolution <= 8) {
            throw new IllegalArgumentException("HogHash is only defined for bit resolution > 8");
        }
        this.numBins = 4;
        this.cellWidth = 2;
        int width = (int)Math.round(Math.sqrt(bitResolution / this.numBins) * (double)this.cellWidth);
        if (width % 2 != 0) {
            --width;
        }
        if ((estimatedLength = (double)(width / this.cellWidth * (height = width) / this.cellWidth * this.numBins)) < (double)bitResolution) {
            width += 2;
        }
        if ((estimatedLength = (double)(width / this.cellWidth * height / this.cellWidth * this.numBins)) < (double)bitResolution) {
            height += 2;
        }
        this.width = width;
        this.height = height;
        this.xCells = width / this.cellWidth;
        this.yCells = height / this.cellWidth;
    }

    @Override
    protected BigInteger hash(BufferedImage image, HashBuilder hash) {
        FastPixel fp = this.createPixelAccessor(image, this.width, this.height);
        int[][] lum = fp.getLuma();
        int[][][] hog = this.computeHogFeatures(lum);
        for (int xCell = 0; xCell < this.xCells; ++xCell) {
            for (int yCell = 0; yCell < this.yCells; ++yCell) {
                int bin;
                int lastMax = Integer.MIN_VALUE;
                int maxIndex = -1;
                for (bin = 0; bin < this.numBins; ++bin) {
                    if (hog[xCell][yCell][bin] <= lastMax) continue;
                    lastMax = hog[xCell][yCell][bin];
                    maxIndex = bin;
                }
                for (bin = 0; bin < this.numBins; ++bin) {
                    if (bin == maxIndex) {
                        hash.prependZero();
                        continue;
                    }
                    hash.prependOne();
                }
            }
        }
        return hash.toBigInteger();
    }

    protected int[][][] computeHogFeatures(int[][] lum) {
        double binFac = (180.0 - 180.0 / (double)this.numBins) / (double)(this.numBins - 1);
        double[][] magnitude = new double[this.width][this.height];
        double[][] direction = new double[this.width][this.height];
        for (int x = 1; x < this.width - 1; ++x) {
            for (int y = 1; y < this.height - 1; ++y) {
                int hGradient = lum[x + 1][y] - lum[x - 1][y];
                int vGradient = lum[x][y - 1] - lum[x][y + 1];
                magnitude[x][y] = Math.sqrt(hGradient * hGradient + vGradient * vGradient);
                direction[x][y] = hGradient == 0 ? 180.0 : Math.toDegrees(Math.atan((double)vGradient / (double)hGradient)) + 90.0;
            }
        }
        int[][][] hog = new int[this.xCells][this.yCells][this.numBins];
        for (int x = 0; x < this.width; ++x) {
            int xCellIndex = x / this.cellWidth;
            for (int y = 0; y < this.height; ++y) {
                int yCellIndex = y / this.cellWidth;
                double binF = direction[x][y] / binFac;
                int bin = (int)binF;
                double nextBucketShare = MathUtil.getFractionalPart((double)binF);
                double currentShare = 1.0 - nextBucketShare;
                if (bin != this.numBins) {
                    int[] nArray = hog[xCellIndex][yCellIndex];
                    int n = bin;
                    nArray[n] = (int)((double)nArray[n] + currentShare * magnitude[x][y]);
                    if (bin == this.numBins - 1) {
                        int[] nArray2 = hog[xCellIndex][yCellIndex];
                        nArray2[0] = (int)((double)nArray2[0] + nextBucketShare * magnitude[x][y]);
                        continue;
                    }
                    int[] nArray3 = hog[xCellIndex][yCellIndex];
                    int n2 = bin + 1;
                    nArray3[n2] = (int)((double)nArray3[n2] + nextBucketShare * magnitude[x][y]);
                    continue;
                }
                int[] nArray = hog[xCellIndex][yCellIndex];
                nArray[0] = (int)((double)nArray[0] + currentShare * magnitude[x][y]);
            }
        }
        return hog;
    }

    protected double[][][] blockNormalization(int[][][] hog) {
        double[][][] normalizedHog = new double[this.xCells][this.yCells][this.numBins];
        for (int xCell = 0; xCell < this.xCells; ++xCell) {
            for (int yCell = 0; yCell < this.yCells; ++yCell) {
                int bin;
                int vectorLength = 0;
                for (bin = 0; bin < this.numBins; ++bin) {
                    vectorLength += hog[xCell][yCell][bin] * hog[xCell][yCell][bin];
                }
                if (yCell < this.yCells - 1) {
                    for (bin = 0; bin < this.numBins; ++bin) {
                        vectorLength += hog[xCell][yCell + 1][bin] * hog[xCell][yCell + 1][bin];
                    }
                } else if (yCell - 1 > 0) {
                    for (bin = 0; bin < this.numBins; ++bin) {
                        vectorLength += hog[xCell][yCell - 1][bin] * hog[xCell][yCell - 1][bin];
                    }
                }
                if (xCell < this.xCells - 1) {
                    for (bin = 0; bin < this.numBins; ++bin) {
                        vectorLength += hog[xCell + 1][yCell][bin] * hog[xCell + 1][yCell][bin];
                    }
                    if (yCell < this.yCells - 1) {
                        for (bin = 0; bin < this.numBins; ++bin) {
                            vectorLength += hog[xCell + 1][yCell + 1][bin] * hog[xCell + 1][yCell + 1][bin];
                        }
                    }
                } else if (xCell - 1 > 0) {
                    for (bin = 0; bin < this.numBins; ++bin) {
                        vectorLength += hog[xCell - 1][yCell][bin] * hog[xCell - 1][yCell][bin];
                    }
                    if (yCell - 1 > 0) {
                        for (bin = 0; bin < this.numBins; ++bin) {
                            vectorLength += hog[xCell - 1][yCell - 1][bin] * hog[xCell - 1][yCell - 1][bin];
                        }
                    }
                }
                double normFactor = Math.sqrt(vectorLength);
                for (int bin2 = 0; bin2 < this.numBins; ++bin2) {
                    normalizedHog[xCell][yCell][bin2] = (double)hog[xCell][yCell][bin2] / normFactor;
                }
            }
        }
        return normalizedHog;
    }

    protected void toImage(File outputFile, BufferedImage originalImage, Color gradientColor, int[][][] hog) {
        int globalMaximum = Integer.MIN_VALUE;
        for (int xCell = 0; xCell < this.xCells; ++xCell) {
            for (int yCell = 0; yCell < this.yCells; ++yCell) {
                int max = ArrayUtil.maximum((int[])hog[xCell][yCell]);
                if (max <= globalMaximum) continue;
                globalMaximum = max;
            }
        }
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        double cellWidth = width / this.xCells;
        double cellHeight = height / this.yCells;
        BufferedImage bImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = (Graphics2D)bImage.getGraphics();
        g2.drawImage(originalImage, 0, 0, width, height, null);
        g2.setPaint(gradientColor);
        g2.setStroke(new BasicStroke(1.0f));
        for (int xCell = 0; xCell < this.xCells; ++xCell) {
            for (int yCell = 0; yCell < this.yCells; ++yCell) {
                for (int bin = 0; bin < this.numBins; ++bin) {
                    int angle = (int)((double)bin * 180.0 / (double)this.numBins);
                    int x = (int)((double)xCell * cellWidth + cellWidth / 2.0);
                    int y = (int)((double)yCell * cellHeight + cellHeight / 2.0);
                    g2.setPaint(ColorUtil.getContrastColor((Color)new Color(originalImage.getRGB(x, y))));
                    double lengthX = cellWidth * (double)hog[xCell][yCell][bin] / (double)globalMaximum;
                    double lengthY = cellHeight * (double)hog[xCell][yCell][bin] / (double)globalMaximum;
                    int startX = (int)((double)x - Math.cos(Math.toRadians(angle)) * lengthX);
                    int startY = (int)((double)y - Math.sin(Math.toRadians(angle)) * lengthY);
                    int endX = (int)((double)x + Math.cos(Math.toRadians(angle)) * lengthX);
                    int endY = (int)((double)y + Math.sin(Math.toRadians(angle)) * lengthY);
                    g2.drawLine(startX, startY, endX, endY);
                }
            }
        }
        g2.dispose();
        try {
            ImageIO.write((RenderedImage)bImage, "png", outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void toImage(File outputFile, BufferedImage originalImage, Color gradientColor, double[][][] normalizedHog) {
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        double cellWidth = width / this.xCells;
        double cellHeight = height / this.yCells;
        BufferedImage bImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = (Graphics2D)bImage.getGraphics();
        g2.drawImage(originalImage, 0, 0, width, height, null);
        g2.setPaint(gradientColor);
        g2.setStroke(new BasicStroke(1.0f));
        for (int xCell = 0; xCell < this.xCells; ++xCell) {
            for (int yCell = 0; yCell < this.yCells; ++yCell) {
                for (int bin = 0; bin < this.numBins; ++bin) {
                    int angle = (int)((double)bin * 180.0 / (double)this.numBins);
                    int x = (int)((double)xCell * cellWidth + cellWidth / 2.0);
                    int y = (int)((double)yCell * cellHeight + cellHeight / 2.0);
                    g2.setPaint(ColorUtil.getContrastColor((Color)new Color(originalImage.getRGB(x, y))));
                    double lengthX = cellWidth * normalizedHog[xCell][yCell][bin] * 0.75;
                    double lengthY = cellHeight * normalizedHog[xCell][yCell][bin] * 0.75;
                    int startX = (int)((double)x - Math.cos(Math.toRadians(angle)) * lengthX);
                    int startY = (int)((double)y - Math.sin(Math.toRadians(angle)) * lengthY);
                    int endX = (int)((double)x + Math.cos(Math.toRadians(angle)) * lengthX);
                    int endY = (int)((double)y + Math.sin(Math.toRadians(angle)) * lengthY);
                    g2.drawLine(startX, startY, endX, endY);
                }
            }
        }
        g2.dispose();
        try {
            ImageIO.write((RenderedImage)bImage, "png", outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [numBins=" + this.numBins + "]";
    }

    @Override
    protected int precomputeAlgoId() {
        return Objects.hash("com.github.kilianB.hashAlgorithms.experimental." + this.getClass().getSimpleName(), this.width, this.height, this.cellWidth, this.numBins);
    }
}

