/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms;

import dev.brachtendorf.graphics.FastPixel;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashBuilder;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jtransforms.dct.DoubleDCT_1D;

public class RotPHash
extends HashingAlgorithm {
    private static final long serialVersionUID = -7498910506857652806L;
    private final boolean truncateKey;
    private int width;
    private int height;
    private double centerX;
    private double centerY;
    private double widthPerSection;
    private int buckets;

    public RotPHash(int bitResolution) {
        this(bitResolution, false);
    }

    public RotPHash(int bitResolution, boolean truncateKey) {
        super(bitResolution);
        this.truncateKey = truncateKey;
        this.buckets = (int)Math.sqrt((double)this.bitResolution * 1.27) + 3;
        this.height = this.width = this.buckets * 2;
        this.widthPerSection = (double)this.width / 2.0 / (double)this.buckets;
        this.centerY = this.centerX = (double)(this.width - 1) / 2.0;
    }

    @Override
    protected BigInteger hash(BufferedImage image, HashBuilder hash) {
        FastPixel fp = this.createPixelAccessor(image, this.width, this.height);
        List[] values = new List[this.buckets];
        for (int i = 0; i < this.buckets; ++i) {
            values[i] = new ArrayList();
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int bucket = this.computePartition(x, y);
                if (bucket >= this.buckets) continue;
                values[bucket].add(fp.getLuma(x, y));
            }
        }
        int length = 0;
        for (int i = 0; i < this.buckets; ++i) {
            int j;
            Collections.sort(values[i]);
            double[] arr = new double[values[i].size()];
            for (int j2 = 0; j2 < arr.length; ++j2) {
                arr[j2] = ((Integer)values[i].get(j2)).intValue();
            }
            DoubleDCT_1D dct = new DoubleDCT_1D((long)arr.length);
            dct.forward(arr, false);
            double avg = 0.0;
            int count = arr.length / 4 - 1;
            for (j = 2; j < count; ++j) {
                avg += arr[j] / (double)(count - 2);
            }
            for (j = 2; !(j >= count || this.truncateKey && length == this.bitResolution); ++length, ++j) {
                if (arr[j] >= avg) {
                    hash.prependZero();
                    continue;
                }
                hash.prependOne();
            }
        }
        return hash.toBigInteger();
    }

    protected int computePartition(double originalX, double originalY) {
        double distance = Math.sqrt((originalX -= this.centerX) * originalX + (originalY -= this.centerY) * originalY);
        return (int)(distance / this.widthPerSection);
    }

    @Override
    protected int precomputeAlgoId() {
        return Objects.hash("com.github.kilianB.hashAlgorithms." + this.getClass().getSimpleName(), this.width, this.height, this.truncateKey);
    }
}

