/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.datastructures.tree.binaryTreeFuzzy;

import dev.brachtendorf.MathUtil;
import dev.brachtendorf.jimagehash.datastructures.tree.AbstractBinaryTree;
import dev.brachtendorf.jimagehash.datastructures.tree.NodeInfo;
import dev.brachtendorf.jimagehash.datastructures.tree.Result;
import dev.brachtendorf.jimagehash.datastructures.tree.binaryTree.Leaf;
import dev.brachtendorf.jimagehash.datastructures.tree.binaryTree.Node;
import dev.brachtendorf.jimagehash.datastructures.tree.binaryTreeFuzzy.FuzzyNode;
import dev.brachtendorf.jimagehash.hash.FuzzyHash;
import dev.brachtendorf.jimagehash.hash.Hash;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;

public class FuzzyBinaryTree
extends AbstractBinaryTree<FuzzyHash> {
    private static final long serialVersionUID = -246416483525585695L;
    private int hashLengthDebug = -1;

    public FuzzyBinaryTree(boolean ensureHashConsistency) {
        super(ensureHashConsistency);
        this.root = new FuzzyNode();
    }

    public void addHash(FuzzyHash hash) {
        this.addHash((Hash)hash, hash);
    }

    public void addHashes(FuzzyHash ... fuzzyHashs) {
        for (FuzzyHash h : fuzzyHashs) {
            this.addHash(h);
        }
    }

    public void addHashes(Collection<FuzzyHash> fuzzyHashs) {
        for (FuzzyHash h : fuzzyHashs) {
            this.addHash(h);
        }
    }

    @Override
    protected void addHash(Hash hash, FuzzyHash value) {
        if (this.ensureHashConsistency) {
            if (this.algoId == 0) {
                this.algoId = hash.getAlgorithmId();
            } else if (this.algoId != hash.getAlgorithmId()) {
                throw new IllegalStateException("Tried to add an incompatible hash to the binary tree");
            }
        }
        if (this.hashLengthDebug < 0) {
            this.hashLengthDebug = hash.getBitResolution();
        }
        FuzzyNode currentNode = (FuzzyNode)this.root;
        for (int i = hash.getBitResolution() - 1; i > 0; --i) {
            boolean bit = hash.getBitUnsafe(i);
            FuzzyNode tempNode = (FuzzyNode)currentNode.getChild(bit);
            currentNode = tempNode == null ? (FuzzyNode)currentNode.createChild(bit) : tempNode;
            currentNode.setNodeBounds(value.getWeightedDistance(i, bit));
        }
        boolean bit = hash.getBit(0);
        Node leafNode = currentNode.getChild(bit);
        Leaf leaf = leafNode != null ? (Leaf)leafNode : (Leaf)currentNode.setChild(bit, new Leaf());
        leaf.addData(value);
        ++this.hashCount;
    }

    @Override
    public List<Result<FuzzyHash>> getNearestNeighbour(Hash hash) {
        if (this.ensureHashConsistency && this.algoId != hash.getAlgorithmId()) {
            throw new IllegalStateException("Tried to add an incompatible hash to the binary tree");
        }
        int treeDepth = hash.getBitResolution();
        if (this.hashLengthDebug != treeDepth) {
            throw new IllegalStateException("Tried to get neareast neighbor an incompatible hash to the binary tree");
        }
        PriorityQueue queue = new PriorityQueue();
        ArrayList<Result<FuzzyHash>> resultCandidates = new ArrayList<Result<FuzzyHash>>();
        double curBestDistance = Double.MAX_VALUE;
        queue.add(new NodeInfo(this.root, 0.0, treeDepth));
        while (!queue.isEmpty()) {
            NodeInfo info = (NodeInfo)queue.poll();
            if (info.distance > curBestDistance) continue;
            if (info.depth == 0) {
                Leaf leaf = (Leaf)info.node;
                for (FuzzyHash o : leaf.getData()) {
                    double normalizedDistance = o.weightedDistance(hash);
                    double actualDistance = normalizedDistance * (double)hash.getBitResolution();
                    if (curBestDistance > actualDistance) {
                        resultCandidates.clear();
                        curBestDistance = actualDistance;
                        resultCandidates.add(new Result<FuzzyHash>(o, actualDistance, normalizedDistance));
                        continue;
                    }
                    if (!MathUtil.isDoubleEquals((double)curBestDistance, (double)actualDistance, (double)1.0E-8)) continue;
                    resultCandidates.add(new Result<FuzzyHash>(o, actualDistance, normalizedDistance));
                }
                continue;
            }
            boolean bit = hash.getBitUnsafe(info.depth - 1);
            for (int i = 0; i < 2; ++i) {
                Node node;
                boolean left;
                boolean bl = left = i == 0;
                if (info.depth != 1) {
                    double newDistance;
                    node = (FuzzyNode)info.node.getChild(left);
                    if (node == null || !((newDistance = bit == left ? info.distance + node.lowerDistance : info.distance + (1.0 - node.uppderDistance)) <= curBestDistance)) continue;
                    queue.add(new NodeInfo(node, newDistance, info.depth - 1));
                    continue;
                }
                try {
                    node = (Leaf)info.node.getChild(left);
                    if (node == null) continue;
                    queue.add(new NodeInfo(node, info.distance, info.depth - 1));
                    continue;
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                    this.printTree();
                    System.out.println(info);
                    System.out.println(this.hashLengthDebug + " " + treeDepth);
                    throw e;
                }
            }
        }
        return resultCandidates;
    }

    @Override
    public PriorityQueue<Result<FuzzyHash>> getElementsWithinHammingDistance(Hash hash, int maxDistance) {
        return null;
    }
}

