/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.datastructures;

import dev.brachtendorf.ArrayUtil;
import dev.brachtendorf.StringUtil;
import dev.brachtendorf.jimagehash.hash.FuzzyHash;
import dev.brachtendorf.jimagehash.hash.Hash;
import dev.brachtendorf.mutable.MutableDouble;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClusterResult {
    protected int numberOfClusters;
    protected int[] clusterIndex;
    protected HashMap<Integer, DoubleSummaryStatistics> stats = new HashMap();
    protected HashMap<Hash, Integer> entryToDataIndex = new HashMap();
    protected HashMap<Integer, List<Integer>> entriesInCluster = new HashMap();
    protected HashMap<Integer, FuzzyHash> clusters = new HashMap();
    Map<Integer, List<Hash>> hashesByCluster = new HashMap<Integer, List<Hash>>();
    private double sseSum;
    private HashMap<Integer, MutableDouble> sse = new HashMap();
    private HashMap<Integer, MutableDouble> silhouetteCoef = new HashMap();
    private boolean silhouetteCoefComputed = false;

    public ClusterResult(int[] clusterIndex, Hash[] hashes) {
        int cluster;
        int i;
        this.clusterIndex = clusterIndex;
        this.numberOfClusters = ArrayUtil.maximum((int[])clusterIndex) + 1;
        for (int cluster2 = -1; cluster2 < this.numberOfClusters; ++cluster2) {
            this.clusters.put(cluster2, new FuzzyHash());
            this.stats.put(cluster2, new DoubleSummaryStatistics());
            this.sse.put(cluster2, new MutableDouble(0.0));
            this.silhouetteCoef.put(cluster2, new MutableDouble(0.0));
            this.hashesByCluster.put(cluster2, new ArrayList());
            this.entriesInCluster.put(cluster2, new ArrayList());
        }
        for (i = 0; i < hashes.length; ++i) {
            cluster = clusterIndex[i];
            this.clusters.get(cluster).mergeFast(hashes[i]);
            this.hashesByCluster.get(cluster).add(hashes[i]);
            this.entryToDataIndex.put(hashes[i], i);
            this.entriesInCluster.get(cluster).add(i);
        }
        for (i = 0; i < hashes.length; ++i) {
            cluster = clusterIndex[i];
            double distance = this.clusters.get(cluster).weightedDistance(hashes[i]);
            this.stats.get(cluster).accept(distance);
            MutableDouble m = this.sse.get(cluster);
            m.setValue(m.getValue() + distance * distance);
        }
        for (i = 0; i < this.numberOfClusters; ++i) {
            this.sseSum += this.sse.get(i).doubleValue();
        }
    }

    private void calculateSilhouetteCoefficient() {
        if (this.silhouetteCoefComputed) {
            return;
        }
        Hash[] hashes = this.entryToDataIndex.keySet().toArray(new Hash[this.entryToDataIndex.size()]);
        for (int i = 0; i < hashes.length; ++i) {
            int cluster = this.indexToCluster(this.entryToDataIndex.get(hashes[i]));
            List<Hash> sameCluster = this.hashesByCluster.get(cluster);
            int pointsInCluster = sameCluster.size() - 1;
            double avgDistSameCluster = 0.0;
            for (Hash h : sameCluster) {
                avgDistSameCluster += h.normalizedHammingDistanceFast(hashes[i]);
            }
            double minAvgDistanceOtherCluster = Double.MAX_VALUE;
            for (int j = 0; j < this.numberOfClusters; ++j) {
                if (j != cluster) {
                    double avgDistanceOtherCluster = 0.0;
                    List<Hash> otherCluster = this.hashesByCluster.get(j);
                    pointsInCluster = otherCluster.size();
                    for (Hash h : otherCluster) {
                        avgDistanceOtherCluster += h.normalizedHammingDistanceFast(hashes[i]) / (double)pointsInCluster;
                    }
                    if (avgDistanceOtherCluster < minAvgDistanceOtherCluster) {
                        minAvgDistanceOtherCluster = avgDistanceOtherCluster;
                    }
                }
                double silhoutteCoefficient = avgDistSameCluster < minAvgDistanceOtherCluster ? 1.0 - avgDistSameCluster / minAvgDistanceOtherCluster : minAvgDistanceOtherCluster / avgDistSameCluster - 1.0;
                MutableDouble sil = this.silhouetteCoef.get(cluster);
                sil.setValue(sil.getValue() + silhoutteCoefficient / (double)sameCluster.size());
            }
        }
        this.silhouetteCoefComputed = true;
    }

    public void printInformation(boolean includeSilhouetteCoefficient) {
        if (includeSilhouetteCoefficient) {
            this.calculateSilhouetteCoefficient();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Observations: ").append(this.clusterIndex.length).append("\n").append("Number of Clusters: ").append(this.numberOfClusters).append("\n");
        int clusterLength = StringUtil.charsNeeded((Number)this.numberOfClusters);
        int obsLength = StringUtil.charsNeeded((Number)this.clusterIndex.length);
        String format = "%-" + clusterLength + "d (Obs:%" + obsLength + "d) |";
        int hLength = Math.max("Clusters: |".length(), clusterLength + 1 + 5 + obsLength + 2);
        sb.append(String.format("%-" + hLength + "s", "Clusters: ")).append("| Centeroids:\n");
        double silouetteCoeffificient = 0.0;
        DecimalFormat df = new DecimalFormat(".000");
        DecimalFormat sseDf = new DecimalFormat("0.00E0");
        for (int i = 0; i < this.numberOfClusters; ++i) {
            sb.append(String.format(format, i, this.hashesByCluster.get(i).size()));
            sb.append(" [ ").append(this.clusters.get(i)).append("] ");
            if (includeSilhouetteCoefficient) {
                sb.append("Silhouette Coef: ").append(df.format(silouetteCoeffificient += this.silhouetteCoef.get(i).getValue().doubleValue()));
            }
            sb.append(" SSE:").append(sseDf.format(this.sse.get(i).doubleValue())).append("\n");
        }
        sb.append("SSE: " + df.format(this.sseSum)).append("\n");
        if (includeSilhouetteCoefficient) {
            sb.append("Silhouette Coef/#clusters: " + df.format(silouetteCoeffificient / (double)this.numberOfClusters)).append("\n");
        }
        System.out.println(sb.toString());
    }

    public Map<Integer, List<Hash>> getClusters() {
        return this.hashesByCluster;
    }

    public List<Hash> getCluster(int cluster) {
        return this.hashesByCluster.get(cluster);
    }

    public DoubleSummaryStatistics getStats(int cluster) {
        return this.stats.get(cluster);
    }

    public int[] getClusterData() {
        return this.clusterIndex;
    }

    public double getSumSquaredError(int cluster) {
        return this.sse.get(cluster).doubleValue();
    }

    public double getSumSquaredError() {
        return this.sseSum;
    }

    public double getSilhouetteCoef(int cluster) {
        this.calculateSilhouetteCoefficient();
        return this.silhouetteCoef.get(cluster).doubleValue();
    }

    public int getBestFitCluster(Hash testHash) {
        int bestCategory = -2;
        double bestFitness = Double.MAX_VALUE;
        for (Map.Entry<Integer, FuzzyHash> entry : this.clusters.entrySet()) {
            double dist = entry.getValue().weightedDistance(testHash);
            if (!(dist < bestFitness)) continue;
            bestFitness = dist;
            bestCategory = entry.getKey();
        }
        return bestCategory;
    }

    public int lookupClusterIdForKnownHash(Hash testHash) {
        return this.indexToCluster(this.entryToDataIndex.get(testHash));
    }

    public List<Integer> clusterIndexToDataIndex(int clusterIndex) {
        return this.entriesInCluster.get(clusterIndex);
    }

    public int indexToCluster(int index) {
        return this.clusterIndex[index];
    }

    public FuzzyHash getCenteroid(int cluster) {
        return this.clusters.get(cluster);
    }

    public Map<Integer, Double> getPotentialFits(Hash testHash, double sigma) {
        HashMap<Integer, Double> resultValue = new HashMap<Integer, Double>();
        int bestCategory = -2;
        double bestFitness = Double.MAX_VALUE;
        for (Map.Entry<Integer, FuzzyHash> entry : this.clusters.entrySet()) {
            double upperBound;
            double dist = entry.getValue().weightedDistance(testHash);
            if (dist <= (upperBound = this.stats.get(entry.getKey()).getMax()) * sigma) {
                resultValue.put(entry.getKey(), dist);
            }
            if (!(dist < bestFitness)) continue;
            bestFitness = dist;
            bestCategory = entry.getKey();
        }
        if (!resultValue.containsKey(bestCategory)) {
            resultValue.put(bestCategory, 1.0);
        }
        resultValue = resultValue.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(e -> (Integer)e.getKey(), e -> (Double)e.getValue(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        return resultValue;
    }
}

