/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.validators.core;

import de.redsix.dmncheck.result.ValidationResult;
import de.redsix.dmncheck.validators.core.ValidationContext;
import de.redsix.dmncheck.validators.core.Validator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public abstract class GenericValidator<S extends ModelElementInstance, T extends ModelElementInstance>
implements Validator {
    protected abstract boolean isApplicable(S var1, ValidationContext var2);

    protected abstract List<ValidationResult> validate(T var1, ValidationContext var2);

    protected abstract Class<S> getClassUsedToCheckApplicability();

    protected abstract Class<T> getClassUnderValidation();

    @Override
    public List<ValidationResult> apply(DmnModelInstance dmnModelInstance) {
        ValidationContext validationContext = new ValidationContext(dmnModelInstance);
        Collection elements = dmnModelInstance.getModelElementsByType(this.getClassUsedToCheckApplicability());
        return elements.stream().filter(element -> this.isApplicable(element, validationContext)).flatMap(this::getElementsUnderValidation).flatMap(element -> this.validate(element, validationContext).stream()).collect(Collectors.toList());
    }

    private Stream<T> getElementsUnderValidation(S element) {
        Stream childElementsUnderValidation = element.getChildElementsByType(this.getClassUnderValidation()).stream();
        if (this.getClassUnderValidation().isInstance(element)) {
            return Stream.concat(childElementsUnderValidation, Stream.of(element));
        }
        return childElementsUnderValidation;
    }
}

