/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.result;

import de.redsix.dmncheck.result.Severity;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class ValidationResult {
    private final Severity severity;
    private final String message;
    private final ModelElementInstance element;
    public static final Builder.MessageStep init = message -> new Builder.SeverityStep(){
        private Severity severity = Severity.ERROR;

        @Override
        public Builder.BuildStep element(final ModelElementInstance element) {
            return new Builder.BuildStep(){

                @Override
                public ModelElementInstance getElement() {
                    return element;
                }

                @Override
                public Severity getSeverity() {
                    return severity;
                }

                @Override
                public String getMessage() {
                    return message;
                }

                @Override
                public ValidationResult build() {
                    return new ValidationResult(message, element, severity);
                }
            };
        }

        @Override
        public Severity getSeverity() {
            return this.severity;
        }

        @Override
        public Builder.ElementStep severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public String getMessage() {
            return message;
        }
    };

    private ValidationResult(String message, ModelElementInstance element, Severity severity) {
        this.message = message;
        this.element = element;
        this.severity = severity;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public ModelElementInstance getElement() {
        return this.element;
    }

    public String toString() {
        return this.message;
    }

    public static final class Builder {

        public static interface BuildStep {
            public ModelElementInstance getElement();

            public Severity getSeverity();

            public String getMessage();

            public ValidationResult build();
        }

        public static interface ElementStep {
            public BuildStep element(ModelElementInstance var1);

            public Severity getSeverity();

            public String getMessage();
        }

        public static interface SeverityStep
        extends ElementStep {
            public ElementStep severity(Severity var1);

            @Override
            public String getMessage();
        }

        @FunctionalInterface
        public static interface MessageStep {
            public SeverityStep message(String var1);
        }
    }
}

