/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.dmncheck.drg;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.AuthorityRequirement;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.Definitions;
import org.camunda.bpm.model.dmn.instance.DrgElement;
import org.camunda.bpm.model.dmn.instance.InformationRequirement;
import org.camunda.bpm.model.dmn.instance.InputData;
import org.camunda.bpm.model.dmn.instance.KnowledgeSource;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;

public class RequirementGraph
extends DirectedAcyclicGraph<DrgElement, DefaultEdge> {
    private final Definitions definitions;

    public RequirementGraph(Class<? extends DefaultEdge> edgeClass, Definitions definitions) {
        super(edgeClass);
        this.definitions = definitions;
    }

    public Definitions getDefinitions() {
        return this.definitions;
    }

    public static RequirementGraph from(DmnModelInstance dmnModelInstance) throws IllegalArgumentException {
        Collection decisions = dmnModelInstance.getModelElementsByType(Decision.class);
        Collection knowledgeSources = dmnModelInstance.getModelElementsByType(KnowledgeSource.class);
        Collection inputData = dmnModelInstance.getModelElementsByType(InputData.class);
        RequirementGraph drg = new RequirementGraph(DefaultEdge.class, dmnModelInstance.getDefinitions());
        Stream.of(decisions, knowledgeSources, inputData).flatMap(Collection::stream).forEach(arg_0 -> ((RequirementGraph)drg).addVertex(arg_0));
        for (Decision decision : decisions) {
            decision.getInformationRequirements().stream().flatMap(RequirementGraph::collectDrgElements).forEach(drgElement -> {
                DefaultEdge cfr_ignored_0 = (DefaultEdge)drg.addEdge(drgElement, decision);
            });
            decision.getAuthorityRequirements().stream().flatMap(RequirementGraph::collectDrgElements).forEach(drgElement -> {
                DefaultEdge cfr_ignored_0 = (DefaultEdge)drg.addEdge(drgElement, decision);
            });
        }
        for (KnowledgeSource knowledgeSource : knowledgeSources) {
            knowledgeSource.getAuthorityRequirement().stream().flatMap(RequirementGraph::collectDrgElements).forEach(drgElement -> {
                DefaultEdge cfr_ignored_0 = (DefaultEdge)drg.addEdge(drgElement, knowledgeSource);
            });
        }
        return drg;
    }

    private static Stream<DrgElement> collectDrgElements(InformationRequirement informationRequirement) {
        return Stream.of(informationRequirement.getRequiredDecision(), informationRequirement.getRequiredInput()).filter(Objects::nonNull);
    }

    private static Stream<DrgElement> collectDrgElements(AuthorityRequirement authorityRequirement) {
        return Stream.of(authorityRequirement.getRequiredDecision(), authorityRequirement.getRequiredInput(), authorityRequirement.getRequiredAuthority()).filter(Objects::nonNull);
    }
}

