/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.presentation.frontend.impl.commandline.v2;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.digitalcollections.iiif.presentation.model.api.v2.Canvas;
import de.digitalcollections.iiif.presentation.model.api.v2.ImageResource;
import de.digitalcollections.iiif.presentation.model.api.v2.Manifest;
import de.digitalcollections.iiif.presentation.model.api.v2.PropertyValue;
import de.digitalcollections.iiif.presentation.model.api.v2.Service;
import de.digitalcollections.iiif.presentation.model.impl.jackson.v2.IiifPresentationApiObjectMapper;
import de.digitalcollections.iiif.presentation.model.impl.v2.CanvasImpl;
import de.digitalcollections.iiif.presentation.model.impl.v2.ImageImpl;
import de.digitalcollections.iiif.presentation.model.impl.v2.ImageResourceImpl;
import de.digitalcollections.iiif.presentation.model.impl.v2.ManifestImpl;
import de.digitalcollections.iiif.presentation.model.impl.v2.PropertyValueSimpleImpl;
import de.digitalcollections.iiif.presentation.model.impl.v2.SequenceImpl;
import de.digitalcollections.iiif.presentation.model.impl.v2.ServiceImpl;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ManifestGenerator {
    public static void main(String[] args) throws ParseException, JsonProcessingException, IOException, URISyntaxException {
        Options options = new Options();
        options.addOption("d", true, "Absolute file path to the directory containing the image files.");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("d")) {
            String imageDirectoryPath = cmd.getOptionValue("d");
            Path imageDirectory = Paths.get(imageDirectoryPath, new String[0]);
            final ArrayList<Path> files = new ArrayList<Path>();
            try {
                Files.walkFileTree(imageDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (!attrs.isDirectory() && file.getFileName().toString().endsWith("jpg")) {
                            files.add(file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Collections.sort(files, new Comparator(){

                public int compare(Object fileOne, Object fileTwo) {
                    String filename1 = ((Path)fileOne).getFileName().toString();
                    String filename2 = ((Path)fileTwo).getFileName().toString();
                    try {
                        Integer number1 = Integer.parseInt(filename1.substring(0, filename1.lastIndexOf(".")));
                        Integer number2 = Integer.parseInt(filename2.substring(0, filename2.lastIndexOf(".")));
                        return number1.compareTo(number2);
                    }
                    catch (NumberFormatException nfe) {
                        return filename1.compareToIgnoreCase(filename2);
                    }
                }
            });
            ManifestGenerator.generateManifest(imageDirectory.getFileName().toString(), files);
        } else {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("ManifestGenerator", options);
        }
    }

    private static void generateManifest(String imageDirectoryName, List<Path> files) throws JsonProcessingException, IOException, URISyntaxException {
        String urlPrefix = "http://www.yourdomain.com/iiif/presentation/2.0.0/";
        PropertyValueSimpleImpl manifestLabel = new PropertyValueSimpleImpl("Manifest for " + imageDirectoryName);
        ManifestImpl manifest = new ManifestImpl(urlPrefix + imageDirectoryName + "/manifest.json", (PropertyValue)manifestLabel);
        ArrayList<SequenceImpl> sequences = new ArrayList<SequenceImpl>();
        manifest.setSequences(sequences);
        SequenceImpl seq1 = new SequenceImpl((PropertyValue)new PropertyValueSimpleImpl("Current page order"));
        seq1.setId(urlPrefix + imageDirectoryName + "/sequence/normal");
        sequences.add(seq1);
        ArrayList<Canvas> canvases = new ArrayList<Canvas>();
        seq1.setCanvases(canvases);
        int i = 0;
        for (Path file : files) {
            ManifestGenerator.addPage(urlPrefix, imageDirectoryName, canvases, ++i, file);
        }
        ManifestGenerator mg = new ManifestGenerator();
        String json = mg.generateJson((Manifest)manifest);
        System.out.println(json);
    }

    private static void addPage(String urlPrefix, String imageDirectoryName, List<Canvas> canvases, int pageCounter, Path file) throws IOException, URISyntaxException {
        Path fileName = file.getFileName();
        System.out.println(fileName.toAbsolutePath());
        BufferedImage bimg = ImageIO.read(file.toFile());
        int width = bimg.getWidth();
        int height = bimg.getHeight();
        CanvasImpl canvas1 = new CanvasImpl(urlPrefix + imageDirectoryName + "/canvas/canvas-" + pageCounter, (PropertyValue)new PropertyValueSimpleImpl("p-" + pageCounter), height, width);
        canvases.add((Canvas)canvas1);
        ArrayList<ImageImpl> images = new ArrayList<ImageImpl>();
        canvas1.setImages(images);
        ImageImpl image1 = new ImageImpl();
        image1.setOn(canvas1.getId());
        images.add(image1);
        ImageResourceImpl imageResource1 = new ImageResourceImpl(urlPrefix + imageDirectoryName + "/" + fileName.toString());
        imageResource1.setHeight(height);
        imageResource1.setWidth(width);
        image1.setResource((ImageResource)imageResource1);
        ServiceImpl service1 = new ServiceImpl(urlPrefix + imageDirectoryName + "/" + fileName.toString() + "?");
        service1.setContext("http://iiif.io/api/image/2/context.json");
        service1.setProfile("http://iiif.io/api/image/2/level1.json");
        imageResource1.setService((Service)service1);
    }

    public String generateJson(Manifest manifest) throws JsonProcessingException {
        IiifPresentationApiObjectMapper mapper = new IiifPresentationApiObjectMapper();
        String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)manifest);
        return json;
    }
}

