/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.web.filter;

import com.yomahub.tlog.web.wrapper.RequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ReplaceStreamFilter
implements Filter {
    private String[] excludedPathArray;
    private static final String DEFAULT_FILTER_EXCLUDED_PATHS = "/static/*,*.html,*.js,*.ico,*.jpg,*.png,*.css";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.excludedPathArray = DEFAULT_FILTER_EXCLUDED_PATHS.split(",");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (!this.isFilterExcludeRequest(httpServletRequest)) {
            RequestWrapper requestWrapper = new RequestWrapper(httpServletRequest);
            chain.doFilter((ServletRequest)requestWrapper, response);
        }
    }

    public void destroy() {
    }

    private boolean isFilterExcludeRequest(HttpServletRequest request) {
        if (null != this.excludedPathArray && this.excludedPathArray.length > 0) {
            String url = request.getRequestURI();
            for (String ecludedUrl : this.excludedPathArray) {
                String targetUrl;
                if (ecludedUrl.startsWith("*.")) {
                    if (!url.endsWith(ecludedUrl.substring(1))) continue;
                    return true;
                }
                if (ecludedUrl.endsWith("/*")) {
                    String prffixStr;
                    if (!ecludedUrl.startsWith("/")) {
                        ecludedUrl = "/" + ecludedUrl;
                    }
                    if (!url.startsWith(prffixStr = request.getContextPath() + ecludedUrl.substring(0, ecludedUrl.length() - 1))) continue;
                    return true;
                }
                if (!ecludedUrl.startsWith("/")) {
                    ecludedUrl = "/" + ecludedUrl;
                }
                if (!url.equals(targetUrl = request.getContextPath() + ecludedUrl)) continue;
                return true;
            }
        }
        return false;
    }
}

