/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.inter.security.encrypt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorAdaptor;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.encrypt.BigParamEncryptMode;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.utils.Encodes;
import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class YopAesEncryptor
extends YopEncryptorAdaptor {
    private static final String AES_ALG = "AES";
    private static final String AES_CBC_PCK_ALG = "AES/CBC/PKCS5Padding";
    private static final byte[] AES_IV = YopAesEncryptor.initIv("AES/CBC/PKCS5Padding");
    private static final ThreadLocal<Map<String, Cipher>> cipherThreadLocal = new ThreadLocal<Map<String, Cipher>>(){

        @Override
        protected Map<String, Cipher> initialValue() {
            HashMap map = Maps.newHashMap();
            try {
                map.put(YopAesEncryptor.AES_CBC_PCK_ALG, Cipher.getInstance(YopAesEncryptor.AES_CBC_PCK_ALG));
                map.put(YopAesEncryptor.AES_ALG, Cipher.getInstance(YopAesEncryptor.AES_ALG));
            }
            catch (Exception e) {
                throw new YopClientException("error happened when initial with AES alg", (Throwable)e);
            }
            return map;
        }
    };

    public List<String> supportedAlgs() {
        return Lists.newArrayList((Object[])new String[]{AES_ALG, AES_CBC_PCK_ALG});
    }

    public EncryptOptions doInitEncryptOptions(String encryptAlg) throws Exception {
        return new EncryptOptions((Object)Encodes.encodeUrlSafeBase64((byte[])this.generateRandomKey()), "RSA", encryptAlg, Encodes.encodeUrlSafeBase64((byte[])AES_IV), Encodes.encodeUrlSafeBase64((byte[])"yop".getBytes("UTF-8")));
    }

    private byte[] generateRandomKey() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance(AES_ALG);
        generator.init(128);
        return generator.generateKey().getEncoded();
    }

    public byte[] encrypt(byte[] plain, EncryptOptions options) {
        try {
            Cipher initializedCipher = this.getInitializedCipher(1, options);
            return initializedCipher.doFinal(plain);
        }
        catch (Throwable t) {
            throw new YopClientException("error happened when encrypt data", t);
        }
    }

    public InputStream encrypt(InputStream plain, EncryptOptions options) {
        if (BigParamEncryptMode.chunked.equals((Object)options.getBigParamEncryptMode())) {
            throw new YopClientException("chunked encrypt for files not supported now");
        }
        return new CipherInputStream(plain, this.getInitializedCipher(1, options, false));
    }

    public byte[] decrypt(byte[] cipher, EncryptOptions options) {
        try {
            Cipher initializedCipher = this.getInitializedCipher(2, options);
            return initializedCipher.doFinal(cipher);
        }
        catch (Throwable t) {
            throw new YopClientException("error happened when decrypt data", t);
        }
    }

    public InputStream decrypt(InputStream cipher, EncryptOptions options) {
        if (BigParamEncryptMode.chunked.equals((Object)options.getBigParamEncryptMode())) {
            throw new YopClientException("chunked decrypt for files not supported now");
        }
        return new CipherInputStream(cipher, this.getInitializedCipher(2, options, false));
    }

    private static byte[] initIv(String fullAlg) {
        try {
            Cipher cipher = Cipher.getInstance(fullAlg);
            int blockSize = cipher.getBlockSize();
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
        catch (Exception e) {
            int blockSize = 16;
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
    }

    private Cipher getInitializedCipher(int mode, EncryptOptions encryptOptions) {
        return this.getInitializedCipher(mode, encryptOptions, true);
    }

    private Cipher getInitializedCipher(int mode, EncryptOptions encryptOptions, boolean shareMode) {
        try {
            byte[] key = Encodes.decodeBase64((String)((YopSymmetricCredentials)encryptOptions.getCredentials()).getCredential());
            Cipher cipher = shareMode ? cipherThreadLocal.get().get(encryptOptions.getAlg()) : Cipher.getInstance(encryptOptions.getAlg());
            SecretKeySpec secretKey = new SecretKeySpec(key, AES_ALG);
            if (StringUtils.isNotEmpty((CharSequence)encryptOptions.getIv())) {
                byte[] ivBytes = Encodes.decodeBase64((String)encryptOptions.getIv());
                IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes);
                cipher.init(mode, (Key)secretKey, ivParameterSpec);
                return cipher;
            }
            cipher.init(mode, secretKey);
            return cipher;
        }
        catch (Throwable throwable) {
            throw new YopClientException("error happened when initialize cipher", throwable);
        }
    }
}

