/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.system;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicBoolean;

public class CatchSigTerm {
    public static void setup(final AtomicBoolean signalCaught) {
        signalCaught.set(false);
        try {
            Class<?> shc = Class.forName("sun.misc.SignalHandler");
            Class<?> ssc = Class.forName("sun.misc.Signal");
            InvocationHandler ihandler = new InvocationHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    AtomicBoolean atomicBoolean = signalCaught;
                    synchronized (atomicBoolean) {
                        signalCaught.set(true);
                        signalCaught.notifyAll();
                    }
                    return null;
                }
            };
            Object shandler = Proxy.newProxyInstance(CatchSigTerm.class.getClassLoader(), new Class[]{shc}, ihandler);
            Constructor<?>[] c = ssc.getDeclaredConstructors();
            assert (c.length == 1);
            Object sigterm = c[0].newInstance("TERM");
            Method m = CatchSigTerm.findMethod(ssc, "handle");
            assert (m != null);
            m.invoke(null, sigterm, shandler);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            System.err.println("FAILED setting up signal catching: " + e);
        }
    }

    private static Method findMethod(Class<?> c, String name) {
        for (Method m : c.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }
}

