/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.concurrent;

import com.yahoo.yolean.concurrent.ResourceFactory;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public final class ResourcePool<T>
implements Iterable<T> {
    private final Deque<T> pool = new ArrayDeque<T>();
    private final ResourceFactory<T> factory;

    public ResourcePool(ResourceFactory<T> factory) {
        this.factory = factory;
    }

    public final T alloc() {
        return this.pool.isEmpty() ? this.factory.create() : this.pool.pop();
    }

    public final void free(T e) {
        this.pool.push(e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.pool.iterator();
    }
}

