/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.concurrent;

import com.yahoo.yolean.concurrent.ResourceFactory;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentResourcePool<T>
implements Iterable<T> {
    private final Queue<T> pool = new ConcurrentLinkedQueue<T>();
    private final ResourceFactory<T> factory;

    public ConcurrentResourcePool(ResourceFactory<T> factory) {
        this.factory = factory;
    }

    public final T alloc() {
        T e = this.pool.poll();
        return e != null ? e : this.factory.create();
    }

    public final void free(T e) {
        this.pool.offer(e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.pool.iterator();
    }
}

