/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.chain;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class EnumeratedIdentitySet<T>
implements Set<T> {
    private int counter = 0;
    private final Map<T, Integer> set = new IdentityHashMap<T, Integer>();

    public EnumeratedIdentitySet(Collection<? extends T> collection) {
        this.addAll(collection);
    }

    public EnumeratedIdentitySet() {
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.set.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.keySet().toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.set.keySet().toArray(a);
    }

    @Override
    public boolean add(T t) {
        if (this.set.containsKey(t)) {
            return false;
        }
        this.set.put(t, this.counter++);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean changed = false;
        for (T t : collection) {
            changed |= this.add(t);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.set.keySet().retainAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object o : collection) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.counter = 0;
    }

    public List<T> insertionOrderedList() {
        if (this.set.isEmpty()) {
            this.counter = 0;
            return Collections.emptyList();
        }
        if (this.counter >= this.set.size() * 2 + 20) {
            this.renumber();
        }
        return EnumeratedIdentitySet.getKeysSortedByValue(this.set, this.counter);
    }

    private static <KEY> List<KEY> getKeysSortedByValue(Map<KEY, Integer> set, int maxValue) {
        Object[] result = (Object[])Array.newInstance(EnumeratedIdentitySet.headKey(set).getClass(), maxValue);
        for (Map.Entry<KEY, Integer> entry : set.entrySet()) {
            result[entry.getValue().intValue()] = entry.getKey();
        }
        return EnumeratedIdentitySet.removeNulls(result);
    }

    private static <T> T headKey(Map<T, ?> map) {
        return map.entrySet().iterator().next().getKey();
    }

    static <T> List<T> removeNulls(T[] list) {
        int insertionSpot = 0;
        for (int i = 0; i < list.length; ++i) {
            T element = list[i];
            if (element == null) continue;
            list[insertionSpot] = element;
            ++insertionSpot;
        }
        return Arrays.asList(list).subList(0, insertionSpot);
    }

    List<Integer> numbers() {
        return new ArrayList<Integer>(this.set.values());
    }

    private void renumber() {
        SortedMap<Integer, T> invertedSet = EnumeratedIdentitySet.invertedSortedMap(this.set);
        int i = 0;
        for (Map.Entry<Integer, T> entry : invertedSet.entrySet()) {
            this.set.put(entry.getValue(), i++);
        }
        this.counter = i;
    }

    private static <K, V> SortedMap<V, K> invertedSortedMap(Map<K, V> map) {
        TreeMap<V, K> result = new TreeMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }
}

