/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.chain;

import com.yahoo.yolean.chain.ChainCycleException;
import com.yahoo.yolean.chain.EnumeratedIdentitySet;
import com.yahoo.yolean.chain.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DirectedGraph {
    private IdentityHashMap<Vertex, List<Vertex>> incommingEdges = new IdentityHashMap();
    private List<Vertex> vertices = new ArrayList<Vertex>();
    private List<Vertex> beginningVertices = new ArrayList<Vertex>();
    private List<Vertex> endingVertices = new ArrayList<Vertex>();

    DirectedGraph() {
    }

    public void addVertex(Vertex vertex) {
        this.vertices.add(vertex);
    }

    public void addBeginningVertex(Vertex vertex) {
        this.beginningVertices.add(vertex);
    }

    public void addEndingVertex(Vertex vertex) {
        this.endingVertices.add(vertex);
    }

    public void addEdge(Vertex start, Vertex end) {
        DirectedGraph.get(this.incommingEdges, end).add(start);
    }

    private static List<Vertex> get(Map<Vertex, List<Vertex>> edgeMap, Vertex key) {
        List<Vertex> value = edgeMap.get(key);
        return value == null ? DirectedGraph.addEmptyList(edgeMap, key) : value;
    }

    private static List<Vertex> addEmptyList(Map<Vertex, List<Vertex>> edgeMap, Vertex key) {
        ArrayList<Vertex> value = new ArrayList<Vertex>();
        edgeMap.put(key, value);
        return value;
    }

    public List<Vertex> topologicalSort() {
        EnumeratedIdentitySet<Vertex> visitedVertices = new EnumeratedIdentitySet<Vertex>();
        for (Vertex v : this.beginningVertices) {
            this.topologicalSortVisit(v, visitedVertices);
        }
        this.warnIfVisitedEndVertices(visitedVertices);
        for (Vertex v : this.vertices) {
            this.topologicalSortVisit(v, visitedVertices);
        }
        for (Vertex v : this.endingVertices) {
            this.topologicalSortVisit(v, visitedVertices);
        }
        return visitedVertices.insertionOrderedList();
    }

    private void warnIfVisitedEndVertices(EnumeratedIdentitySet<Vertex> visitedVertices) {
    }

    private void topologicalSortVisit(Vertex vertex, Set<Vertex> visitedVertices) {
        this.topologicalSortVisitImpl(vertex, visitedVertices, new EnumeratedIdentitySet<Vertex>());
    }

    private void topologicalSortVisitImpl(Vertex vertex, Set<Vertex> visitedVertices, EnumeratedIdentitySet<Vertex> cycleDetector) {
        if (cycleDetector.contains(vertex)) {
            throw new ChainCycleException(cycleDetector.insertionOrderedList());
        }
        if (visitedVertices.contains(vertex)) {
            return;
        }
        cycleDetector.add(vertex);
        for (Vertex endVertex : this.emptyIfNull(this.incommingEdges.get(vertex))) {
            this.topologicalSortVisitImpl(endVertex, visitedVertices, cycleDetector);
        }
        visitedVertices.add(vertex);
        cycleDetector.remove(vertex);
    }

    private <T> List<T> emptyIfNull(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }
}

