/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.chain;

import com.yahoo.yolean.chain.After;
import com.yahoo.yolean.chain.Before;
import com.yahoo.yolean.chain.Provides;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Dependencies<T> {
    final Order<T> before;
    final Order<T> after;
    final List<String> provided;

    private Dependencies(Order<T> before, Order<T> after, String[] provided) {
        this.before = before;
        this.after = after;
        this.provided = Dependencies.copyList(provided);
    }

    @SafeVarargs
    public static <T> Dependencies<T> before(T ... components) {
        return new Dependencies(new Order(components, null, null), Order.emptyOrder(), null);
    }

    @SafeVarargs
    public static <T> Dependencies<T> before(Class<? extends T> ... classes) {
        return new Dependencies(new Order(null, classes, null), Order.emptyOrder(), null);
    }

    public static <T> Dependencies<T> before(String ... providedNames) {
        return new Dependencies(new Order(null, null, providedNames), Order.emptyOrder(), null);
    }

    @SafeVarargs
    public static <T> Dependencies<T> after(T ... components) {
        return new Dependencies(Order.emptyOrder(), new Order(components, null, null), null);
    }

    @SafeVarargs
    public static <T> Dependencies<T> after(Class<? extends T> ... classes) {
        return new Dependencies(Order.emptyOrder(), new Order(null, classes, null), null);
    }

    public static <T> Dependencies<T> after(String ... providedNames) {
        return new Dependencies(Order.emptyOrder(), new Order(null, null, providedNames), null);
    }

    public static <T> Dependencies<T> provides(String ... names) {
        return new Dependencies<T>(Order.emptyOrder(), Order.emptyOrder(), names);
    }

    public static <T> Dependencies<T> emptyDependencies() {
        return new Dependencies<T>(Order.emptyOrder(), Order.emptyOrder(), null);
    }

    static <T> Dependencies<T> union(List<Dependencies<? extends T>> dependenciesList) {
        if (dependenciesList.size() > 1) {
            Dependencies<T> result = Dependencies.emptyDependencies();
            for (Dependencies<T> dependencies : dependenciesList) {
                result = super.union(dependencies);
            }
            return result;
        }
        if (dependenciesList.size() == 0) {
            return Dependencies.emptyDependencies();
        }
        return dependenciesList.get(0);
    }

    private Dependencies<T> union(Dependencies<? extends T> other) {
        List<String> lst = Dependencies.listUnion(this.provided, other.provided);
        return new Dependencies<T>(((Order)this.before).union((Order)other.before), ((Order)this.after).union((Order)other.after), lst.toArray(new String[lst.size()]));
    }

    private static <T> List<T> listUnion(List<? extends T> list1, List<? extends T> list2) {
        ArrayList<T> union = new ArrayList<T>(list1);
        union.removeAll(list2);
        union.addAll(list2);
        return union;
    }

    static <T> Dependencies<T> getAnnotatedDependencies(T component) {
        return new Dependencies(new Order(null, null, Dependencies.getSymbols(component, Before.class)), new Order(null, null, Dependencies.getSymbols(component, After.class)), Dependencies.getProvidedSymbols(component));
    }

    private static <T> String[] getProvidedSymbols(T component) {
        List<String> lst = Dependencies.allOf(Dependencies.getSymbols(component, Provides.class), component.getClass().getName());
        return lst.toArray(new String[lst.size()]);
    }

    @SafeVarargs
    static <T> List<T> allOf(List<T> elements, T ... otherElements) {
        ArrayList<T> result = new ArrayList<T>(elements);
        result.addAll(Arrays.asList(otherElements));
        return result;
    }

    @SafeVarargs
    static <T> List<T> allOf(T[] elements, T ... otherElements) {
        return Dependencies.allOf(Arrays.asList(elements), otherElements);
    }

    private static <T> List<String> getSymbols(T component, Class<? extends Annotation> annotationClass) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Dependencies.annotationSymbols(component, annotationClass));
        return result;
    }

    private static <T> Collection<String> annotationSymbols(T component, Class<? extends Annotation> annotationClass) {
        try {
            ArrayList<String> values = new ArrayList<String>();
            for (Class<?> clazz = component.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                Annotation annotation = clazz.getAnnotation(annotationClass);
                if (annotation == null) continue;
                values.addAll(Arrays.asList((String[])annotationClass.getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0])));
            }
            return values;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <U> List<U> copyList(List<U> list) {
        return list == null ? Collections.emptyList() : new ArrayList<U>(list);
    }

    private static <U> List<U> copyList(U[] array) {
        return array == null ? Collections.emptyList() : new ArrayList<U>(Arrays.asList(array));
    }

    static final class Order<T> {
        final List<T> instances;
        final List<Class<? extends T>> classes;
        final List<String> providedNames;

        private Order(T[] instances, Class<? extends T>[] classes, String[] providedNames) {
            this.instances = Dependencies.copyList(instances);
            this.classes = Dependencies.copyList(classes);
            this.providedNames = Dependencies.copyList(providedNames);
        }

        private Order(List<T> instances, List<Class<? extends T>> classes, List<String> providedNames) {
            this.instances = Dependencies.copyList(instances);
            this.classes = Dependencies.copyList(classes);
            this.providedNames = Dependencies.copyList(providedNames);
        }

        private Order<T> union(Order<? extends T> other) {
            return new Order<T>(Dependencies.listUnion(this.instances, other.instances), Dependencies.listUnion(this.classes, other.classes), Dependencies.listUnion(this.providedNames, other.providedNames));
        }

        private static <U> Order<U> emptyOrder() {
            return new Order<Object>((Object[])null, null, null);
        }
    }
}

