/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.chain;

import com.yahoo.yolean.chain.Chain;
import com.yahoo.yolean.chain.Dependencies;
import com.yahoo.yolean.chain.DirectedGraph;
import com.yahoo.yolean.chain.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ChainBuilder<T> {
    private final String chainId;
    private final List<T> components = new ArrayList<T>();
    private final IdentityHashMap<T, Dependencies<T>> dependencies = new IdentityHashMap();

    public ChainBuilder(String chainId) {
        this.chainId = chainId;
    }

    @SafeVarargs
    public final ChainBuilder<T> add(T component, Dependencies<? extends T> ... dependenciesList) {
        if (this.dependencies.containsKey(component)) {
            throw new IllegalArgumentException("The same component cannot be added twice: " + component);
        }
        this.components.add(component);
        List allDependencies = Dependencies.allOf(dependenciesList, Dependencies.getAnnotatedDependencies(component));
        this.dependencies.put(component, Dependencies.union(allDependencies));
        return this;
    }

    public Chain<T> build() {
        DirectedGraph graph = this.buildGraph();
        List<Vertex> sortedVertices = graph.topologicalSort();
        return new Chain<T>(this.chainId, this.components(sortedVertices));
    }

    private DirectedGraph buildGraph() {
        DirectedGraph graph = new DirectedGraph();
        List<ComponentVertex<T>> vertices = this.createVertices();
        this.addVertices(graph, vertices);
        ChainBuilder.addEdges(graph, vertices, this.dependencies);
        return graph;
    }

    private List<ComponentVertex<T>> createVertices() {
        ArrayList<ComponentVertex<T>> vertices = new ArrayList<ComponentVertex<T>>();
        for (T component : this.components) {
            vertices.add(new ComponentVertex(component));
        }
        return vertices;
    }

    private List<T> components(List<Vertex> sortedVertices) {
        ArrayList result = new ArrayList();
        for (Vertex vertex : sortedVertices) {
            if (!(vertex instanceof ComponentVertex)) continue;
            result.add(((ComponentVertex)vertex).component);
        }
        return result;
    }

    private void addVertices(DirectedGraph graph, List<ComponentVertex<T>> vertices) {
        for (ComponentVertex<T> v : vertices) {
            if (this.isBeginningVertex(v)) {
                graph.addBeginningVertex(v);
                continue;
            }
            if (this.isEndingVertex(v)) {
                graph.addEndingVertex(v);
                continue;
            }
            graph.addVertex(v);
        }
    }

    private boolean isBeginningVertex(ComponentVertex<T> v) {
        return this.dependencies.get(v.component).before.providedNames.contains("*");
    }

    private boolean isEndingVertex(ComponentVertex<T> v) {
        return this.dependencies.get(v.component).after.providedNames.contains("*");
    }

    private static <T> void addEdges(DirectedGraph graph, List<ComponentVertex<T>> vertices, IdentityHashMap<T, Dependencies<T>> dependencies) {
        ChainBuilder.addBeforeInstanceEdges(graph, vertices, dependencies);
        ChainBuilder.addAfterInstanceEdges(graph, vertices, dependencies);
        ChainBuilder.addBeforeClassEdges(graph, vertices, dependencies);
        ChainBuilder.addAfterClassEdges(graph, vertices, dependencies);
        ChainBuilder.addBeforeProvidedEdges(graph, vertices, dependencies);
        ChainBuilder.addAfterProvidedEdges(graph, vertices, dependencies);
    }

    private static <T> void addBeforeClassEdges(DirectedGraph graph, List<ComponentVertex<T>> vertices, IdentityHashMap<T, Dependencies<T>> dependencies) {
        for (ComponentVertex<T> vertex : vertices) {
            for (Class clazz : dependencies.get(vertex.component).before.classes) {
                for (Vertex beforeVertex : ChainBuilder.componentsWithClass(vertices, clazz)) {
                    graph.addEdge(vertex, beforeVertex);
                }
            }
        }
    }

    private static <T> void addAfterClassEdges(DirectedGraph graph, List<ComponentVertex<T>> vertices, IdentityHashMap<T, Dependencies<T>> dependencies) {
        for (ComponentVertex<T> vertex : vertices) {
            for (Class clazz : dependencies.get(vertex.component).after.classes) {
                for (Vertex afterVertex : ChainBuilder.componentsWithClass(vertices, clazz)) {
                    graph.addEdge(afterVertex, vertex);
                }
            }
        }
    }

    private static <T> List<Vertex> componentsWithClass(List<ComponentVertex<T>> vertices, Class<? extends T> beforeClass) {
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        for (ComponentVertex<T> vertex : vertices) {
            if (!beforeClass.isInstance(vertex.component)) continue;
            result.add(vertex);
        }
        return result;
    }

    private static <T> void addBeforeInstanceEdges(DirectedGraph graph, List<ComponentVertex<T>> vertices, IdentityHashMap<T, Dependencies<T>> dependencies) {
        IdentityHashMap<T, Vertex> componentToVertex = ChainBuilder.getComponentToVertex(vertices);
        for (ComponentVertex<T> vertex : vertices) {
            for (Object before : dependencies.get(vertex.component).before.instances) {
                Vertex beforeVertex = componentToVertex.get(before);
                if (beforeVertex == null) continue;
                graph.addEdge(vertex, beforeVertex);
            }
        }
    }

    private static <T> void addAfterInstanceEdges(DirectedGraph graph, List<ComponentVertex<T>> vertices, IdentityHashMap<T, Dependencies<T>> dependencies) {
        IdentityHashMap<T, Vertex> componentToVertex = ChainBuilder.getComponentToVertex(vertices);
        for (ComponentVertex<T> vertex : vertices) {
            for (Object after : dependencies.get(vertex.component).after.instances) {
                Vertex afterVertex = componentToVertex.get(after);
                if (afterVertex == null) continue;
                graph.addEdge(afterVertex, vertex);
            }
        }
    }

    private static <T> IdentityHashMap<T, Vertex> getComponentToVertex(List<ComponentVertex<T>> vertices) {
        IdentityHashMap result = new IdentityHashMap();
        for (ComponentVertex<T> vertex : vertices) {
            result.put(vertex.component, vertex);
        }
        return result;
    }

    private static <T> void addBeforeProvidedEdges(DirectedGraph graph, List<ComponentVertex<T>> vertices, IdentityHashMap<T, Dependencies<T>> dependencies) {
        Map<String, Set<Vertex>> providedNames = ChainBuilder.getProvidedNames(vertices, dependencies);
        for (ComponentVertex<T> vertex : vertices) {
            for (String name : dependencies.get(vertex.component).before.providedNames) {
                for (Vertex beforeVertex : ChainBuilder.emptyIfNull(providedNames.get(name))) {
                    graph.addEdge(vertex, beforeVertex);
                }
            }
        }
    }

    private static <T> void addAfterProvidedEdges(DirectedGraph graph, List<ComponentVertex<T>> vertices, IdentityHashMap<T, Dependencies<T>> dependencies) {
        Map<String, Set<Vertex>> providedNames = ChainBuilder.getProvidedNames(vertices, dependencies);
        for (ComponentVertex<T> vertex : vertices) {
            for (String name : dependencies.get(vertex.component).after.providedNames) {
                for (Vertex afterVertex : ChainBuilder.emptyIfNull(providedNames.get(name))) {
                    graph.addEdge(afterVertex, vertex);
                }
            }
        }
    }

    private static <T> Map<String, Set<Vertex>> getProvidedNames(List<ComponentVertex<T>> vertices, IdentityHashMap<T, Dependencies<T>> dependencies) {
        HashMap<String, Set<T>> result = new HashMap<String, Set<T>>();
        for (ComponentVertex<T> vertex : vertices) {
            for (String providedName : dependencies.get(vertex.component).provided) {
                ChainBuilder.getIdentitySet(result, providedName).add(vertex);
            }
            ChainBuilder.addClassName(result, vertex);
        }
        return result;
    }

    private static void addClassName(Map<String, Set<Vertex>> providedNamesToVertex, ComponentVertex<?> vertex) {
        String className = vertex.component.getClass().getName();
        ChainBuilder.getIdentitySet(providedNamesToVertex, className).add(vertex);
    }

    private static <T> Set<T> getIdentitySet(Map<String, Set<T>> map, String key) {
        Set<Object> result = map.get(key);
        if (result == null) {
            result = Collections.newSetFromMap(new IdentityHashMap());
            map.put(key, result);
        }
        return result;
    }

    private static <T> Set<T> emptyIfNull(Set<T> set) {
        return set != null ? set : Collections.emptySet();
    }

    private static class ComponentVertex<T>
    implements Vertex {
        final T component;

        private ComponentVertex(T component) {
            this.component = component;
        }
    }
}

