/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.chain;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class Chain<T>
implements Iterable<T> {
    private final String id;
    private final Collection<T> components;

    @SafeVarargs
    public Chain(String id, T ... components) {
        this(id, Arrays.asList(components));
    }

    public Chain(String id, List<? extends T> components) {
        Objects.requireNonNull(id, "id must be non-null.");
        Objects.requireNonNull(components, "components must be non-null");
        this.components = ImmutableList.copyOf(components);
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.components.iterator();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("chain '").append(this.id).append("'{");
        boolean first = true;
        for (T component : this.components) {
            if (!first) {
                b.append("->");
            } else {
                first = false;
            }
            b.append(" ").append(component.getClass().getSimpleName()).append(" ");
        }
        b.append("}");
        return b.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Chain && this.equals((Chain)other);
    }

    public boolean equals(Chain<?> other) {
        return this.id.equals(other.id) && this.componentsIdentical(this.components, other.components);
    }

    private boolean componentsIdentical(Collection<T> components1, Collection<?> components2) {
        if (components1.size() != components2.size()) {
            return false;
        }
        Iterator<T> iterator1 = components1.iterator();
        Iterator<?> iterator2 = components2.iterator();
        while (iterator1.hasNext()) {
            Object c2;
            T c1 = iterator1.next();
            if (c1 == (c2 = iterator2.next())) continue;
            return false;
        }
        return true;
    }
}

