// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search.vsm;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of vsmsummary
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class VsmsummaryConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "07145fe84cbe44e8e0d54c27f55971b4";
  public final static String CONFIG_DEF_NAME = "vsmsummary";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search.vsm";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search.vsm",
    "outputclass string default=\"\"",
    "fieldmap[].summary string",
    "fieldmap[].document[].field string",
    "fieldmap[].command enum { NONE, FLATTENJUNIPER, FLATTENSPACE } default=NONE"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String outputclass = null;
    public List<Fieldmap.Builder> fieldmap = new ArrayList<>();

    public Builder() { }

    public Builder(VsmsummaryConfig config) {
      outputclass(config.outputclass());
      for (Fieldmap f : config.fieldmap()) {
        fieldmap(new Fieldmap.Builder(f));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.outputclass != null)
        outputclass(__superior.outputclass);
      if (!__superior.fieldmap.isEmpty())
        fieldmap.addAll(__superior.fieldmap);
      return this;
    }

    public Builder outputclass(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      outputclass = __value;
      return this;
    }


    /**
     * Add the given builder to this builder's list of Fieldmap builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder fieldmap(Fieldmap.Builder __builder) {
      fieldmap.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder fieldmap(java.util.function.Consumer<Fieldmap.Builder> __func) {
      Fieldmap.Builder __inner = new Fieldmap.Builder();
      __func.accept(__inner);
      fieldmap.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Fieldmap builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder fieldmap(List<Fieldmap.Builder> __builders) {
      fieldmap = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public VsmsummaryConfig build() {
      return new VsmsummaryConfig(this);
    }

  }

  // The name of the result class that should be generated for documents
  // returned from the VSM. If this value is empty, the first found
  // result class will be used.
  private final StringNode outputclass;
  private final InnerNodeVector<Fieldmap> fieldmap;

  public VsmsummaryConfig(Builder builder) {
    this(builder, true);
  }

  private VsmsummaryConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "vsmsummary must be initialized: " + builder.__uninitialized);

    outputclass = (builder.outputclass == null) ?
        new StringNode("") : new StringNode(builder.outputclass);
    fieldmap = Fieldmap.createVector(builder.fieldmap);
  }

  /**
   * @return vsmsummary.outputclass
   */
  public String outputclass() {
    return outputclass.value();
  }

  /**
   * @return vsmsummary.fieldmap[]
   */
  public List<Fieldmap> fieldmap() {
    return fieldmap;
  }

  /**
   * @param i the index of the value to return
   * @return vsmsummary.fieldmap[]
   */
  public Fieldmap fieldmap(int i) {
    return fieldmap.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(VsmsummaryConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("vsmsummary");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents vsmsummary.fieldmap[]
   */
  public final static class Fieldmap extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "summary"
        ));

      private String summary = null;
      public List<Document.Builder> document = new ArrayList<>();
      private Command.Enum command = null;

      public Builder() { }

      public Builder(Fieldmap config) {
        summary(config.summary());
        for (Document d : config.document()) {
          document(new Document.Builder(d));
        }
        command(config.command());
      }

      private Builder override(Builder __superior) {
        if (__superior.summary != null)
          summary(__superior.summary);
        if (!__superior.document.isEmpty())
          document.addAll(__superior.document);
        if (__superior.command != null)
          command(__superior.command);
        return this;
      }

      public Builder summary(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        summary = __value;
        __uninitialized.remove("summary");
        return this;
      }


      /**
       * Add the given builder to this builder's list of Document builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder document(Document.Builder __builder) {
        document.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder document(java.util.function.Consumer<Document.Builder> __func) {
        Document.Builder __inner = new Document.Builder();
        __func.accept(__inner);
        document.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Document builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder document(List<Document.Builder> __builders) {
        document = __builders;
        return this;
      }

      public Builder command(Command.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        command = __value;
        return this;
      }

      private Builder command(String __value) {
        return command(Command.Enum.valueOf(__value));
      }

      public Fieldmap build() {
        return new Fieldmap(this);
      }

    }

    // Mapping of field names between the result class and the document
    // model. This value represents the name in the result class. Fields
    // not mentioned here will get the identity mapping.
    private final StringNode summary;
    private final InnerNodeVector<Document> document;
    // This command specifies how the document fields should be combined
    // when generating the summary field.
    private final Command command;

    public Fieldmap(Builder builder) {
      this(builder, true);
    }

    private Fieldmap(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "vsmsummary.fieldmap[] must be initialized: " + builder.__uninitialized);

      summary = (builder.summary == null) ?
          new StringNode() : new StringNode(builder.summary);
      document = Document.createVector(builder.document);
      command = (builder.command == null) ?
          new Command(Command.NONE) : new Command(builder.command);
    }

    /**
     * @return vsmsummary.fieldmap[].summary
     */
    public String summary() {
      return summary.value();
    }

    /**
     * @return vsmsummary.fieldmap[].document[]
     */
    public List<Document> document() {
      return document;
    }

    /**
     * @param i the index of the value to return
     * @return vsmsummary.fieldmap[].document[]
     */
    public Document document(int i) {
      return document.get(i);
    }

    /**
     * @return vsmsummary.fieldmap[].command
     */
    public Command.Enum command() {
      return command.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Fieldmap newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldmap");
      return changes;
    }

    private static InnerNodeVector<Fieldmap> createVector(List<Builder> builders) {
        List<Fieldmap> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Fieldmap(b));
        }
        return new InnerNodeVector<Fieldmap>(elems);
    }

    /**
     * This class represents vsmsummary.fieldmap[].document[]
     */
    public final static class Document extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "field"
          ));

        private String field = null;

        public Builder() { }

        public Builder(Document config) {
          field(config.field());
        }

        private Builder override(Builder __superior) {
          if (__superior.field != null)
            field(__superior.field);
          return this;
        }

        public Builder field(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          field = __value;
          __uninitialized.remove("field");
          return this;
        }


        public Document build() {
          return new Document(this);
        }

      }

      // Mapping of field names between the result class and the document
      // model. This field vector represents the names in the document model
      // that should be used as input when generating the summary field.
      private final StringNode field;

      public Document(Builder builder) {
        this(builder, true);
      }

      private Document(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "vsmsummary.fieldmap[].document[] must be initialized: " + builder.__uninitialized);

        field = (builder.field == null) ?
            new StringNode() : new StringNode(builder.field);
      }

      /**
       * @return vsmsummary.fieldmap[].document[].field
       */
      public String field() {
        return field.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Document newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("document");
        return changes;
      }

      private static InnerNodeVector<Document> createVector(List<Builder> builders) {
          List<Document> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Document(b));
          }
          return new InnerNodeVector<Document>(elems);
      }
    }

    /**
     * This class represents vsmsummary.fieldmap[].command
     * 
     * This command specifies how the document fields should be combined
     * when generating the summary field.
     */
    public final static class Command extends EnumNode<Command.Enum> {

      public Command(){
        this.value = null;
      }

      public Command(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {NONE, FLATTENJUNIPER, FLATTENSPACE}
      public final static Enum NONE = Enum.NONE;
      public final static Enum FLATTENJUNIPER = Enum.FLATTENJUNIPER;
      public final static Enum FLATTENSPACE = Enum.FLATTENSPACE;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

}
